/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.compare;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.watcher.condition.Condition;
import org.elasticsearch.watcher.condition.ExecutableCondition;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.support.xcontent.ObjectPath;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class AbstractExecutableCompareCondition<C extends Condition, R extends Condition.Result>
extends ExecutableCondition<C, R> {
    static final Pattern DATE_MATH_PATTERN = Pattern.compile("<\\{(.+)\\}>");
    static final Pattern PATH_PATTERN = Pattern.compile("\\{\\{(.+)\\}\\}");
    private final Clock clock;

    public AbstractExecutableCompareCondition(C condition, ESLogger logger, Clock clock) {
        super(condition, logger);
        this.clock = clock;
    }

    @Override
    public R execute(WatchExecutionContext ctx) {
        HashMap<String, Object> resolvedValues = new HashMap<String, Object>();
        try {
            Map<String, Object> model = Variables.createCtxModel(ctx, ctx.payload());
            return this.doExecute(model, resolvedValues);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] condition for [{}]", (Throwable)e, new Object[]{this.type(), ctx.id()});
            if (resolvedValues.isEmpty()) {
                resolvedValues = null;
            }
            return this.doFailure(resolvedValues, e);
        }
    }

    protected Object resolveConfiguredValue(Map<String, Object> resolvedValues, Map<String, Object> model, Object configuredValue) {
        if (configuredValue instanceof String) {
            Matcher matcher = DATE_MATH_PATTERN.matcher((String)configuredValue);
            if (matcher.matches()) {
                String dateMath = matcher.group(1);
                configuredValue = WatcherDateTimeUtils.parseDateMath(dateMath, DateTimeZone.UTC, this.clock);
                resolvedValues.put(dateMath, WatcherDateTimeUtils.formatDate((DateTime)configuredValue));
            } else {
                matcher = PATH_PATTERN.matcher((String)configuredValue);
                if (matcher.matches()) {
                    String configuredPath = matcher.group(1);
                    configuredValue = ObjectPath.eval(configuredPath, model);
                    resolvedValues.put(configuredPath, configuredValue);
                }
            }
        }
        return configuredValue;
    }

    protected abstract R doExecute(Map<String, Object> var1, Map<String, Object> var2) throws Exception;

    protected abstract R doFailure(Map<String, Object> var1, Exception var2);
}

