/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface Condition
extends ToXContent {
    public String type();

    public static interface Field {
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField STATUS = new ParseField("status", new String[0]);
        public static final ParseField MET = new ParseField("met", new String[0]);
        public static final ParseField REASON = new ParseField("reason", new String[0]);
    }

    public static interface Builder<C extends Condition> {
        public C build();
    }

    public static abstract class Result
    implements ToXContent {
        protected final String type;
        protected final Status status;
        private final String reason;
        protected final boolean met;

        public Result(String type, boolean met) {
            this.status = Status.SUCCESS;
            this.type = type;
            this.met = met;
            this.reason = null;
        }

        protected Result(String type, Exception e) {
            this.status = Status.FAILURE;
            this.type = type;
            this.met = false;
            this.reason = ExceptionsHelper.detailedMessage((Throwable)e);
        }

        public String type() {
            return this.type;
        }

        public Status status() {
            return this.status;
        }

        public boolean met() {
            assert (this.status == Status.SUCCESS);
            return this.met;
        }

        public String reason() {
            assert (this.status == Status.FAILURE);
            return this.reason;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.TYPE.getPreferredName(), this.type);
            builder.field(Field.STATUS.getPreferredName(), this.status.name().toLowerCase(Locale.ROOT));
            switch (this.status) {
                case SUCCESS: {
                    assert (this.reason == null);
                    builder.field(Field.MET.getPreferredName(), this.met);
                    break;
                }
                case FAILURE: {
                    assert (this.reason != null && !this.met);
                    builder.field(Field.REASON.getPreferredName(), this.reason);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.typeXContent(builder, params);
            return builder.endObject();
        }

        protected abstract XContentBuilder typeXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }
}

