/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.throttler.Throttler;
import org.elasticsearch.watcher.condition.Condition;
import org.elasticsearch.watcher.condition.always.AlwaysCondition;
import org.elasticsearch.watcher.input.Input;
import org.elasticsearch.watcher.input.none.NoneInput;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.support.xcontent.XContentSource;
import org.elasticsearch.watcher.transform.Transform;
import org.elasticsearch.watcher.trigger.Trigger;
import org.elasticsearch.watcher.watch.Watch;

public class WatchSourceBuilder
implements ToXContent {
    private Trigger trigger;
    private Input input = NoneInput.INSTANCE;
    private Condition condition = AlwaysCondition.INSTANCE;
    private Transform transform = null;
    private Map<String, TransformedAction> actions = new HashMap<String, TransformedAction>();
    private TimeValue defaultThrottlePeriod = null;
    private Map<String, Object> metadata;

    public WatchSourceBuilder trigger(Trigger.Builder trigger) {
        return this.trigger((Trigger)trigger.build());
    }

    public WatchSourceBuilder trigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public WatchSourceBuilder input(Input.Builder input) {
        return this.input((Input)input.build());
    }

    public WatchSourceBuilder input(Input input) {
        this.input = input;
        return this;
    }

    public WatchSourceBuilder condition(Condition.Builder condition) {
        return this.condition((Condition)condition.build());
    }

    public WatchSourceBuilder condition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public WatchSourceBuilder transform(Transform transform) {
        this.transform = transform;
        return this;
    }

    public WatchSourceBuilder transform(Transform.Builder transform) {
        return this.transform((Transform)transform.build());
    }

    public WatchSourceBuilder defaultThrottlePeriod(TimeValue throttlePeriod) {
        this.defaultThrottlePeriod = throttlePeriod;
        return this;
    }

    public WatchSourceBuilder addAction(String id, Action.Builder action) {
        return this.addAction(id, null, null, (Action)action.build());
    }

    public WatchSourceBuilder addAction(String id, TimeValue throttlePeriod, Action.Builder action) {
        return this.addAction(id, throttlePeriod, null, (Action)action.build());
    }

    public WatchSourceBuilder addAction(String id, Transform.Builder transform, Action.Builder action) {
        return this.addAction(id, null, (Transform)transform.build(), (Action)action.build());
    }

    public WatchSourceBuilder addAction(String id, TimeValue throttlePeriod, Transform.Builder transform, Action.Builder action) {
        return this.addAction(id, throttlePeriod, (Transform)transform.build(), (Action)action.build());
    }

    public WatchSourceBuilder addAction(String id, TimeValue throttlePeriod, Transform transform, Action action) {
        this.actions.put(id, new TransformedAction(id, action, throttlePeriod, transform));
        return this;
    }

    public WatchSourceBuilder metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public XContentSource build() throws IOException {
        return new XContentSource(this.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.trigger == null) {
            throw Exceptions.illegalState("failed to build watch source. no trigger defined", new Object[0]);
        }
        builder.startObject(Watch.Field.TRIGGER.getPreferredName()).field(this.trigger.type(), (ToXContent)this.trigger, params).endObject();
        builder.startObject(Watch.Field.INPUT.getPreferredName()).field(this.input.type(), (ToXContent)this.input, params).endObject();
        builder.startObject(Watch.Field.CONDITION.getPreferredName()).field(this.condition.type(), (ToXContent)this.condition, params).endObject();
        if (this.transform != null) {
            builder.startObject(Watch.Field.TRANSFORM.getPreferredName()).field(this.transform.type(), (ToXContent)this.transform, params).endObject();
        }
        if (this.defaultThrottlePeriod != null) {
            builder.field(Watch.Field.THROTTLE_PERIOD.getPreferredName(), this.defaultThrottlePeriod.toString());
        }
        builder.startObject(Watch.Field.ACTIONS.getPreferredName());
        for (Map.Entry<String, TransformedAction> entry : this.actions.entrySet()) {
            builder.field(entry.getKey(), (ToXContent)entry.getValue(), params);
        }
        builder.endObject();
        if (this.metadata != null) {
            builder.field(Watch.Field.METADATA.getPreferredName(), this.metadata);
        }
        return builder.endObject();
    }

    public BytesReference buildAsBytes(XContentType contentType) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.bytes();
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("failed to render watch source as bytes", (Throwable)ioe, new Object[0]);
        }
    }

    static class TransformedAction
    implements ToXContent {
        private final String id;
        private final Action action;
        @Nullable
        private final TimeValue throttlePeriod;
        @Nullable
        private final Transform transform;

        public TransformedAction(String id, Action action, @Nullable TimeValue throttlePeriod, @Nullable Transform transform) {
            this.id = id;
            this.throttlePeriod = throttlePeriod;
            this.transform = transform;
            this.action = action;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.throttlePeriod != null) {
                builder.field(Throttler.Field.THROTTLE_PERIOD.getPreferredName(), (Object)this.throttlePeriod);
            }
            if (this.transform != null) {
                builder.startObject(Transform.Field.TRANSFORM.getPreferredName()).field(this.transform.type(), (ToXContent)this.transform, params).endObject();
            }
            builder.field(this.action.type(), (ToXContent)this.action, params);
            return builder.endObject();
        }
    }
}

