/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.webhook;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.webhook.ExecutableWebhookAction;
import org.elasticsearch.watcher.actions.webhook.WebhookAction;
import org.elasticsearch.watcher.support.http.HttpClient;
import org.elasticsearch.watcher.support.http.HttpRequestTemplate;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class WebhookActionFactory
extends ActionFactory<WebhookAction, ExecutableWebhookAction> {
    private final HttpClient httpClient;
    private final HttpRequestTemplate.Parser requestTemplateParser;
    private final TextTemplateEngine templateEngine;

    @Inject
    public WebhookActionFactory(Settings settings, HttpClient httpClient, HttpRequestTemplate.Parser requestTemplateParser, TextTemplateEngine templateEngine) {
        super(Loggers.getLogger(ExecutableWebhookAction.class, (Settings)settings, (String[])new String[0]));
        this.httpClient = httpClient;
        this.requestTemplateParser = requestTemplateParser;
        this.templateEngine = templateEngine;
    }

    @Override
    public String type() {
        return "webhook";
    }

    @Override
    public WebhookAction parseAction(String watchId, String actionId, XContentParser parser) throws IOException {
        return WebhookAction.parse(watchId, actionId, parser, this.requestTemplateParser);
    }

    @Override
    public ExecutableWebhookAction createExecutable(WebhookAction action) {
        return new ExecutableWebhookAction(action, this.actionLogger, this.httpClient, this.templateEngine);
    }
}

