/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.throttler;

import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.watcher.actions.throttler.AckThrottler;
import org.elasticsearch.watcher.actions.throttler.PeriodThrottler;
import org.elasticsearch.watcher.actions.throttler.Throttler;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.support.clock.Clock;

public class ActionThrottler
implements Throttler {
    private static final AckThrottler ACK_THROTTLER = new AckThrottler();
    private final WatcherLicensee watcherLicensee;
    private final PeriodThrottler periodThrottler;
    private final AckThrottler ackThrottler;

    public ActionThrottler(Clock clock, @Nullable TimeValue throttlePeriod, WatcherLicensee watcherLicensee) {
        this(new PeriodThrottler(clock, throttlePeriod), ACK_THROTTLER, watcherLicensee);
    }

    ActionThrottler(PeriodThrottler periodThrottler, AckThrottler ackThrottler, WatcherLicensee watcherLicensee) {
        this.periodThrottler = periodThrottler;
        this.ackThrottler = ackThrottler;
        this.watcherLicensee = watcherLicensee;
    }

    public TimeValue throttlePeriod() {
        return this.periodThrottler != null ? this.periodThrottler.period() : null;
    }

    @Override
    public Throttler.Result throttle(String actionId, WatchExecutionContext ctx) {
        Throttler.Result throttleResult;
        if (!this.watcherLicensee.isExecutingActionsAllowed()) {
            return Throttler.Result.throttle("watcher license does not allow action execution", new Object[0]);
        }
        if (this.periodThrottler != null && (throttleResult = this.periodThrottler.throttle(actionId, ctx)).throttle()) {
            return throttleResult;
        }
        return this.ackThrottler.throttle(actionId, ctx);
    }
}

