/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.slack.service;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.watcher.actions.slack.service.message.SlackMessage;
import org.elasticsearch.watcher.support.http.HttpRequest;
import org.elasticsearch.watcher.support.http.HttpResponse;

public class SentMessages
implements ToXContent,
Iterable<SentMessage> {
    private String accountName;
    private List<SentMessage> messages;

    public SentMessages(String accountName, List<SentMessage> messages) {
        this.accountName = accountName;
        this.messages = messages;
    }

    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public Iterator<SentMessage> iterator() {
        return this.messages.iterator();
    }

    public int count() {
        return this.messages.size();
    }

    public List<SentMessage> asList() {
        return Collections.unmodifiableList(this.messages);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.ACCOUNT, this.accountName);
        builder.startArray(Field.SENT_MESSAGES);
        for (SentMessage message : this.messages) {
            message.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    static interface Field {
        public static final XContentBuilderString ACCOUNT = new XContentBuilderString("account");
        public static final XContentBuilderString SENT_MESSAGES = new XContentBuilderString("sent_messages");
        public static final XContentBuilderString STATUS = new XContentBuilderString("status");
        public static final XContentBuilderString REASON = new XContentBuilderString("reason");
        public static final XContentBuilderString REQUEST = new XContentBuilderString("request");
        public static final XContentBuilderString RESPONSE = new XContentBuilderString("response");
        public static final XContentBuilderString MESSAGE = new XContentBuilderString("message");
        public static final XContentBuilderString TO = new XContentBuilderString("to");
    }

    public static class SentMessage
    implements ToXContent {
        final String to;
        final SlackMessage message;
        @Nullable
        final HttpRequest request;
        @Nullable
        final HttpResponse response;
        @Nullable
        final String failureReason;

        public static SentMessage responded(String to, SlackMessage message, HttpRequest request, HttpResponse response) {
            String failureReason = SentMessage.resolveFailureReason(response);
            return new SentMessage(to, message, request, response, failureReason);
        }

        public static SentMessage error(String to, SlackMessage message, String reason) {
            return new SentMessage(to, message, null, null, reason);
        }

        private SentMessage(String to, SlackMessage message, HttpRequest request, HttpResponse response, String failureReason) {
            this.to = to;
            this.message = message;
            this.request = request;
            this.response = response;
            this.failureReason = failureReason;
        }

        public boolean successful() {
            return this.failureReason == null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.failureReason != null) {
                builder.field(Field.STATUS, "failure");
                builder.field(Field.REASON, this.failureReason);
                if (this.request != null) {
                    builder.field(Field.REQUEST);
                    this.request.toXContent(builder, params);
                }
                if (this.response != null) {
                    builder.field(Field.RESPONSE);
                    this.response.toXContent(builder, params);
                }
            } else {
                builder.field(Field.STATUS, "success");
            }
            if (this.to != null) {
                builder.field(Field.TO, this.to);
            }
            builder.field(Field.MESSAGE);
            this.message.toXContent(builder, params, false);
            return builder.endObject();
        }

        private static String resolveFailureReason(HttpResponse response) {
            int status = response.status();
            if (status < 300) {
                return null;
            }
            if (status > 399 && status < 500) {
                return "Bad Request";
            }
            if (status > 499) {
                return "Slack Server Error";
            }
            return "Unknown Error";
        }
    }
}

