/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.slack.service;

import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.watcher.actions.slack.service.SlackAccount;
import org.elasticsearch.watcher.actions.slack.service.SlackAccounts;
import org.elasticsearch.watcher.actions.slack.service.SlackService;
import org.elasticsearch.watcher.shield.WatcherSettingsFilter;
import org.elasticsearch.watcher.support.http.HttpClient;

public class InternalSlackService
extends AbstractLifecycleComponent<SlackService>
implements SlackService {
    private final HttpClient httpClient;
    private volatile SlackAccounts accounts;

    @Inject
    public InternalSlackService(Settings settings, HttpClient httpClient, NodeSettingsService nodeSettingsService, WatcherSettingsFilter settingsFilter) {
        super(settings);
        this.httpClient = httpClient;
        nodeSettingsService.addListener(new NodeSettingsService.Listener(){

            public void onRefreshSettings(Settings settings) {
                InternalSlackService.this.reset(settings);
            }
        });
        settingsFilter.filterOut("watcher.actions.slack.service.account.*.url");
    }

    protected void doStart() {
        this.reset(this.settings);
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    @Override
    public SlackAccount getDefaultAccount() {
        return this.accounts.account(null);
    }

    @Override
    public SlackAccount getAccount(String name) {
        return this.accounts.account(name);
    }

    void reset(Settings nodeSettings) {
        Settings.Builder builder = Settings.builder();
        String prefix = "watcher.actions.slack.service";
        for (String setting : this.settings.getAsMap().keySet()) {
            if (!setting.startsWith(prefix)) continue;
            builder.put(setting.substring(prefix.length() + 1), this.settings.get(setting));
        }
        if (nodeSettings != this.settings) {
            for (String setting : nodeSettings.getAsMap().keySet()) {
                if (!setting.startsWith(prefix)) continue;
                builder.put(setting.substring(prefix.length() + 1), nodeSettings.get(setting));
            }
        }
        this.accounts = new SlackAccounts(builder.build(), this.httpClient, this.logger);
    }
}

