/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.slack;

import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ExecutableAction;
import org.elasticsearch.watcher.actions.slack.SlackAction;
import org.elasticsearch.watcher.actions.slack.service.SentMessages;
import org.elasticsearch.watcher.actions.slack.service.SlackAccount;
import org.elasticsearch.watcher.actions.slack.service.SlackService;
import org.elasticsearch.watcher.actions.slack.service.message.SlackMessage;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableSlackAction
extends ExecutableAction<SlackAction> {
    private final TextTemplateEngine templateEngine;
    private final SlackService slackService;

    public ExecutableSlackAction(SlackAction action, ESLogger logger, SlackService slackService, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.slackService = slackService;
        this.templateEngine = templateEngine;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        SlackAccount account;
        SlackAccount slackAccount = account = ((SlackAction)this.action).account != null ? this.slackService.getAccount(((SlackAction)this.action).account) : this.slackService.getDefaultAccount();
        if (account == null) {
            throw new IllegalStateException("account [" + ((SlackAction)this.action).account + "] was not found. perhaps it was deleted");
        }
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        SlackMessage message = ((SlackAction)this.action).message.render(ctx.id().watchId(), actionId, this.templateEngine, model, account.getMessageDefaults());
        if (ctx.simulateAction(actionId)) {
            return new SlackAction.Result.Simulated(message);
        }
        SentMessages sentMessages = account.send(message);
        return new SlackAction.Result.Executed(sentMessages);
    }
}

