/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.pagerduty.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.watcher.actions.pagerduty.PagerDutyAction;
import org.elasticsearch.watcher.actions.pagerduty.service.IncidentEvent;
import org.elasticsearch.watcher.support.http.HttpRequest;
import org.elasticsearch.watcher.support.http.HttpResponse;

public class SentEvent
implements ToXContent {
    final IncidentEvent event;
    @Nullable
    final HttpRequest request;
    @Nullable
    final HttpResponse response;
    @Nullable
    final String failureReason;

    public static SentEvent responded(IncidentEvent event, HttpRequest request, HttpResponse response) {
        String failureReason = SentEvent.resolveFailureReason(response);
        return new SentEvent(event, request, response, failureReason);
    }

    public static SentEvent error(IncidentEvent event, String reason) {
        return new SentEvent(event, null, null, reason);
    }

    private SentEvent(IncidentEvent event, HttpRequest request, HttpResponse response, String failureReason) {
        this.event = event;
        this.request = request;
        this.response = response;
        this.failureReason = failureReason;
    }

    public boolean successful() {
        return this.failureReason == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentEvent sentEvent = (SentEvent)o;
        return Objects.equals(this.event, sentEvent.event) && Objects.equals(this.request, sentEvent.request) && Objects.equals(this.failureReason, sentEvent.failureReason);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.request, this.response, this.failureReason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(XField.EVENT.getPreferredName(), (ToXContent)this.event, params);
        if (!this.successful()) {
            builder.field(XField.REASON.getPreferredName(), this.failureReason);
            if (this.request != null) {
                builder.field(XField.REQUEST.getPreferredName(), (ToXContent)this.request, params);
            }
            if (this.response != null) {
                builder.field(XField.RESPONSE.getPreferredName(), (ToXContent)this.response, params);
            }
        }
        return builder.endObject();
    }

    private static String resolveFailureReason(HttpResponse response) {
        int status = response.status();
        if (status < 300) {
            return null;
        }
        try {
            XContentParser.Token token;
            XContentParser parser = JsonXContent.jsonXContent.createParser(response.body());
            parser.nextToken();
            String message = null;
            ArrayList<String> errors = new ArrayList<String>();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.MESSAGE)) {
                    message = parser.text();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.CODE)) continue;
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.ERRORS)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        errors.add(parser.text());
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not parse pagerduty event response. unexpected field [{}]", new Object[]{currentFieldName});
            }
            StringBuilder sb = new StringBuilder();
            if (message != null) {
                sb.append(message);
            }
            if (!errors.isEmpty()) {
                sb.append(":");
                for (String error : errors) {
                    sb.append(" ").append(error).append(".");
                }
            }
            return sb.toString();
        }
        catch (Exception exception) {
            switch (status) {
                case 400: {
                    return "Bad Request";
                }
                case 401: {
                    return "Unauthorized. The account service api key is invalid.";
                }
                case 403: {
                    return "Forbidden. The account doesn't have permission to send this trigger.";
                }
                case 404: {
                    return "The account used invalid HipChat APIs";
                }
                case 408: {
                    return "Request Timeout. The request took too long to process.";
                }
                case 500: {
                    return "PagerDuty Server Error. Internal error occurred while processing request.";
                }
            }
            return "Unknown Error";
        }
    }

    public static interface XField {
        public static final ParseField EVENT = PagerDutyAction.XField.EVENT;
        public static final ParseField REASON = new ParseField("reason", new String[0]);
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField RESPONSE = new ParseField("response", new String[0]);
        public static final ParseField MESSAGE = new ParseField("message", new String[0]);
        public static final ParseField CODE = new ParseField("code", new String[0]);
        public static final ParseField ERRORS = new ParseField("errors", new String[0]);
    }
}

