/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.pagerduty.service;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyAccount;
import org.elasticsearch.watcher.support.http.HttpClient;

public class PagerDutyAccounts {
    private final Map<String, PagerDutyAccount> accounts;
    private final String defaultAccountName;

    public PagerDutyAccounts(Settings serviceSettings, HttpClient httpClient, ESLogger logger) {
        Settings accountsSettings = serviceSettings.getAsSettings("account");
        this.accounts = new HashMap<String, PagerDutyAccount>();
        for (String name : accountsSettings.names()) {
            Settings accountSettings = accountsSettings.getAsSettings(name);
            PagerDutyAccount account = new PagerDutyAccount(name, accountSettings, serviceSettings, httpClient, logger);
            this.accounts.put(name, account);
        }
        String defaultAccountName = serviceSettings.get("default_account");
        if (defaultAccountName == null) {
            if (this.accounts.isEmpty()) {
                this.defaultAccountName = null;
            } else {
                PagerDutyAccount account = this.accounts.values().iterator().next();
                logger.info("default pager duty account set to [{}]", new Object[]{account.name});
                this.defaultAccountName = account.name;
            }
        } else {
            if (!this.accounts.containsKey(defaultAccountName)) {
                throw new SettingsException("could not find default pagerduty account [" + defaultAccountName + "]");
            }
            this.defaultAccountName = defaultAccountName;
        }
    }

    public PagerDutyAccount account(String name) throws IllegalStateException {
        if (name == null) {
            if (this.defaultAccountName == null) {
                throw new IllegalStateException("cannot find default pagerduty account as no accounts have been configured");
            }
            name = this.defaultAccountName;
        }
        return this.accounts.get(name);
    }
}

