/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.pagerduty.service;

import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyAccount;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyAccounts;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyService;
import org.elasticsearch.watcher.shield.WatcherSettingsFilter;
import org.elasticsearch.watcher.support.http.HttpClient;

public class InternalPagerDutyService
extends AbstractLifecycleComponent<PagerDutyService>
implements PagerDutyService {
    private final HttpClient httpClient;
    private volatile PagerDutyAccounts accounts;

    @Inject
    public InternalPagerDutyService(Settings settings, HttpClient httpClient, NodeSettingsService nodeSettingsService, WatcherSettingsFilter settingsFilter) {
        super(settings);
        this.httpClient = httpClient;
        nodeSettingsService.addListener(new NodeSettingsService.Listener(){

            public void onRefreshSettings(Settings settings) {
                InternalPagerDutyService.this.reset(settings);
            }
        });
        settingsFilter.filterOut("watcher.actions.pagerduty.service.service_api_key", "watcher.actions.pagerduty.service.account.*.service_api_key");
    }

    protected void doStart() {
        this.reset(this.settings);
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    @Override
    public PagerDutyAccount getDefaultAccount() {
        return this.accounts.account(null);
    }

    @Override
    public PagerDutyAccount getAccount(String name) {
        return this.accounts.account(name);
    }

    void reset(Settings nodeSettings) {
        Settings.Builder builder = Settings.builder();
        String prefix = "watcher.actions.pagerduty.service";
        for (String setting : this.settings.getAsMap().keySet()) {
            if (!setting.startsWith(prefix)) continue;
            builder.put(setting.substring(prefix.length() + 1), this.settings.get(setting));
        }
        if (nodeSettings != this.settings) {
            for (String setting : nodeSettings.getAsMap().keySet()) {
                if (!setting.startsWith(prefix)) continue;
                builder.put(setting.substring(prefix.length() + 1), nodeSettings.get(setting));
            }
        }
        this.accounts = new PagerDutyAccounts(builder.build(), this.httpClient, this.logger);
    }
}

