/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.pagerduty.service;

import java.util.Objects;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.actions.pagerduty.service.IncidentEvent;
import org.elasticsearch.watcher.actions.pagerduty.service.IncidentEventContext;

public class IncidentEventDefaults {
    final String description;
    final String incidentKey;
    final String client;
    final String clientUrl;
    final String eventType;
    final boolean attachPayload;
    final Context.LinkDefaults link;
    final Context.ImageDefaults image;

    public IncidentEventDefaults(Settings accountSettings) {
        this.description = accountSettings.get(IncidentEvent.XField.DESCRIPTION.getPreferredName(), null);
        this.incidentKey = accountSettings.get(IncidentEvent.XField.INCIDENT_KEY.getPreferredName(), null);
        this.client = accountSettings.get(IncidentEvent.XField.CLIENT.getPreferredName(), null);
        this.clientUrl = accountSettings.get(IncidentEvent.XField.CLIENT_URL.getPreferredName(), null);
        this.eventType = accountSettings.get(IncidentEvent.XField.EVENT_TYPE.getPreferredName(), null);
        this.attachPayload = accountSettings.getAsBoolean(IncidentEvent.XField.ATTACH_PAYLOAD.getPreferredName(), Boolean.valueOf(false));
        this.link = new Context.LinkDefaults(accountSettings.getAsSettings("link"));
        this.image = new Context.ImageDefaults(accountSettings.getAsSettings("image"));
    }

    static class Context {
        Context() {
        }

        static class ImageDefaults {
            final String href;
            final String src;
            final String alt;

            public ImageDefaults(Settings settings) {
                this.href = settings.get(IncidentEventContext.XField.HREF.getPreferredName(), null);
                this.src = settings.get(IncidentEventContext.XField.SRC.getPreferredName(), null);
                this.alt = settings.get(IncidentEventContext.XField.ALT.getPreferredName(), null);
            }

            public int hashCode() {
                return Objects.hash(this.href, this.src, this.alt);
            }

            public boolean equals(Object obj) {
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                ImageDefaults other = (ImageDefaults)obj;
                return Objects.equals(this.href, other.href) && Objects.equals(this.src, other.src) && Objects.equals(this.alt, other.alt);
            }
        }

        static class LinkDefaults {
            final String href;
            final String text;

            public LinkDefaults(Settings settings) {
                this.href = settings.get(IncidentEventContext.XField.HREF.getPreferredName(), null);
                this.text = settings.get(IncidentEventContext.XField.TEXT.getPreferredName(), null);
            }

            public int hashCode() {
                return Objects.hash(this.href, this.text);
            }

            public boolean equals(Object obj) {
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                LinkDefaults other = (LinkDefaults)obj;
                return Objects.equals(this.href, other.href) && Objects.equals(this.text, other.text);
            }
        }
    }
}

