/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.pagerduty.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.pagerduty.service.IncidentEventContext;
import org.elasticsearch.watcher.actions.pagerduty.service.IncidentEventDefaults;
import org.elasticsearch.watcher.support.http.HttpMethod;
import org.elasticsearch.watcher.support.http.HttpRequest;
import org.elasticsearch.watcher.support.http.Scheme;
import org.elasticsearch.watcher.support.text.TextTemplate;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;
import org.elasticsearch.watcher.watch.Payload;

public class IncidentEvent
implements ToXContent {
    static final String HOST = "events.pagerduty.com";
    static final String PATH = "/generic/2010-04-15/create_event.json";
    final String description;
    @Nullable
    final String incidentKey;
    @Nullable
    final String client;
    @Nullable
    final String clientUrl;
    @Nullable
    final String account;
    final String eventType;
    final boolean attachPayload;
    @Nullable
    final IncidentEventContext[] contexts;

    public IncidentEvent(String description, @Nullable String eventType, @Nullable String incidentKey, @Nullable String client, @Nullable String clientUrl, @Nullable String account, boolean attachPayload, @Nullable IncidentEventContext[] contexts) {
        this.description = description;
        if (description == null) {
            throw new IllegalStateException("could not create pagerduty event. missing required [" + XField.DESCRIPTION.getPreferredName() + "] setting");
        }
        this.incidentKey = incidentKey;
        this.client = client;
        this.clientUrl = clientUrl;
        this.account = account;
        this.attachPayload = attachPayload;
        this.contexts = contexts;
        this.eventType = Strings.hasLength((String)eventType) ? eventType : "trigger";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentEvent template = (IncidentEvent)o;
        return Objects.equals(this.description, template.description) && Objects.equals(this.incidentKey, template.incidentKey) && Objects.equals(this.client, template.client) && Objects.equals(this.clientUrl, template.clientUrl) && Objects.equals(this.attachPayload, template.attachPayload) && Objects.equals(this.eventType, template.eventType) && Objects.equals(this.account, template.account) && Arrays.equals(this.contexts, template.contexts);
    }

    public int hashCode() {
        int result = Objects.hash(this.description, this.incidentKey, this.client, this.clientUrl, this.account, this.attachPayload, this.eventType);
        result = 31 * result + Arrays.hashCode(this.contexts);
        return result;
    }

    public HttpRequest createRequest(final String serviceKey, final Payload payload) throws IOException {
        return HttpRequest.builder(HOST, -1).method(HttpMethod.POST).scheme(Scheme.HTTPS).path(PATH).jsonBody(new ToXContent(){

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field(XField.SERVICE_KEY.getPreferredName(), serviceKey);
                builder.field(XField.EVENT_TYPE.getPreferredName(), IncidentEvent.this.eventType);
                builder.field(XField.DESCRIPTION.getPreferredName(), IncidentEvent.this.description);
                if (IncidentEvent.this.incidentKey != null) {
                    builder.field(XField.INCIDENT_KEY.getPreferredName(), IncidentEvent.this.incidentKey);
                }
                if (IncidentEvent.this.client != null) {
                    builder.field(XField.CLIENT.getPreferredName(), IncidentEvent.this.client);
                }
                if (IncidentEvent.this.clientUrl != null) {
                    builder.field(XField.CLIENT_URL.getPreferredName(), IncidentEvent.this.clientUrl);
                }
                if (IncidentEvent.this.attachPayload) {
                    builder.startObject(XField.DETAILS.getPreferredName());
                    builder.field(XField.PAYLOAD.getPreferredName());
                    payload.toXContent(builder, params);
                    builder.endObject();
                }
                if (IncidentEvent.this.contexts != null && IncidentEvent.this.contexts.length > 0) {
                    builder.startArray(XField.CONTEXT.getPreferredName());
                    for (IncidentEventContext context : IncidentEvent.this.contexts) {
                        context.toXContent(builder, params);
                    }
                    builder.endArray();
                }
                return builder;
            }
        }).build();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(XField.DESCRIPTION.getPreferredName(), this.description);
        if (this.incidentKey != null) {
            builder.field(XField.INCIDENT_KEY.getPreferredName(), this.incidentKey);
        }
        if (this.client != null) {
            builder.field(XField.CLIENT.getPreferredName(), this.client);
        }
        if (this.clientUrl != null) {
            builder.field(XField.CLIENT_URL.getPreferredName(), this.clientUrl);
        }
        if (this.account != null) {
            builder.field(XField.ACCOUNT.getPreferredName(), this.account);
        }
        builder.field(XField.ATTACH_PAYLOAD.getPreferredName(), this.attachPayload);
        if (this.contexts != null) {
            builder.startArray(XField.CONTEXT.getPreferredName());
            for (IncidentEventContext context : this.contexts) {
                context.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    public static Template.Builder templateBuilder(String description) {
        return IncidentEvent.templateBuilder(TextTemplate.inline(description).build());
    }

    public static Template.Builder templateBuilder(TextTemplate description) {
        return new Template.Builder(description);
    }

    static interface XField {
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField EVENT_TYPE = new ParseField("event_type", new String[0]);
        public static final ParseField ACCOUNT = new ParseField("account", new String[0]);
        public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
        public static final ParseField INCIDENT_KEY = new ParseField("incident_key", new String[0]);
        public static final ParseField CLIENT = new ParseField("client", new String[0]);
        public static final ParseField CLIENT_URL = new ParseField("client_url", new String[0]);
        public static final ParseField ATTACH_PAYLOAD = new ParseField("attach_payload", new String[0]);
        public static final ParseField CONTEXT = new ParseField("context", new String[0]);
        public static final ParseField SERVICE_KEY = new ParseField("service_key", new String[0]);
        public static final ParseField PAYLOAD = new ParseField("payload", new String[0]);
        public static final ParseField DETAILS = new ParseField("details", new String[0]);
    }

    public static class Template
    implements ToXContent {
        final TextTemplate description;
        final TextTemplate incidentKey;
        final TextTemplate client;
        final TextTemplate clientUrl;
        final TextTemplate eventType;
        public final String account;
        final Boolean attachPayload;
        final IncidentEventContext.Template[] contexts;

        public Template(TextTemplate description, TextTemplate eventType, TextTemplate incidentKey, TextTemplate client, TextTemplate clientUrl, String account, Boolean attachPayload, IncidentEventContext.Template[] contexts) {
            this.description = description;
            this.eventType = eventType;
            this.incidentKey = incidentKey;
            this.client = client;
            this.clientUrl = clientUrl;
            this.account = account;
            this.attachPayload = attachPayload;
            this.contexts = contexts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.description, template.description) && Objects.equals(this.incidentKey, template.incidentKey) && Objects.equals(this.client, template.client) && Objects.equals(this.clientUrl, template.clientUrl) && Objects.equals(this.eventType, template.eventType) && Objects.equals(this.attachPayload, template.attachPayload) && Objects.equals(this.account, template.account) && Arrays.equals(this.contexts, template.contexts);
        }

        public int hashCode() {
            int result = Objects.hash(this.description, this.eventType, this.incidentKey, this.client, this.clientUrl, this.attachPayload, this.account);
            result = 31 * result + Arrays.hashCode(this.contexts);
            return result;
        }

        public IncidentEvent render(String watchId, String actionId, TextTemplateEngine engine, Map<String, Object> model, IncidentEventDefaults defaults) {
            String description;
            String string = description = this.description != null ? engine.render(this.description, model) : defaults.description;
            String incidentKey = this.incidentKey != null ? engine.render(this.incidentKey, model) : (defaults.incidentKey != null ? defaults.incidentKey : watchId);
            String client = this.client != null ? engine.render(this.client, model) : defaults.client;
            String clientUrl = this.clientUrl != null ? engine.render(this.clientUrl, model) : defaults.clientUrl;
            String eventType = this.eventType != null ? engine.render(this.eventType, model) : defaults.eventType;
            boolean attachPayload = this.attachPayload != null ? this.attachPayload : defaults.attachPayload;
            IncidentEventContext[] contexts = null;
            if (this.contexts != null) {
                contexts = new IncidentEventContext[this.contexts.length];
                for (int i = 0; i < this.contexts.length; ++i) {
                    contexts[i] = this.contexts[i].render(engine, model, defaults);
                }
            }
            return new IncidentEvent(description, eventType, incidentKey, client, clientUrl, this.account, attachPayload, contexts);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(XField.DESCRIPTION.getPreferredName(), (ToXContent)this.description, params);
            if (this.incidentKey != null) {
                builder.field(XField.INCIDENT_KEY.getPreferredName(), (ToXContent)this.incidentKey, params);
            }
            if (this.client != null) {
                builder.field(XField.CLIENT.getPreferredName(), (ToXContent)this.client, params);
            }
            if (this.clientUrl != null) {
                builder.field(XField.CLIENT_URL.getPreferredName(), (ToXContent)this.clientUrl, params);
            }
            if (this.eventType != null) {
                builder.field(XField.EVENT_TYPE.getPreferredName(), (ToXContent)this.eventType, params);
            }
            if (this.attachPayload != null) {
                builder.field(XField.ATTACH_PAYLOAD.getPreferredName(), (Object)this.attachPayload);
            }
            if (this.account != null) {
                builder.field(XField.ACCOUNT.getPreferredName(), this.account);
            }
            if (this.contexts != null) {
                builder.startArray(XField.CONTEXT.getPreferredName());
                for (IncidentEventContext.Template context : this.contexts) {
                    context.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder.endObject();
        }

        public static Template parse(String watchId, String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            TextTemplate incidentKey = null;
            TextTemplate description = null;
            TextTemplate client = null;
            TextTemplate clientUrl = null;
            TextTemplate eventType = null;
            String account = null;
            Boolean attachPayload = null;
            IncidentEventContext.Template[] contexts = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.INCIDENT_KEY)) {
                    try {
                        incidentKey = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{XField.INCIDENT_KEY.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.DESCRIPTION)) {
                    try {
                        description = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{XField.DESCRIPTION.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.CLIENT)) {
                    try {
                        client = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{XField.CLIENT.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.CLIENT_URL)) {
                    try {
                        clientUrl = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{XField.CLIENT_URL.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.ACCOUNT)) {
                    try {
                        account = parser.text();
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{XField.CLIENT_URL.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.EVENT_TYPE)) {
                    try {
                        eventType = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{XField.EVENT_TYPE.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.ATTACH_PAYLOAD)) {
                    if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        attachPayload = parser.booleanValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}], expected a boolean value but found [{}] instead", new Object[]{XField.ATTACH_PAYLOAD.getPreferredName(), token});
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.CONTEXT)) {
                    if (token != XContentParser.Token.START_ARRAY) continue;
                    ArrayList<IncidentEventContext.Template> list = new ArrayList<IncidentEventContext.Template>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        try {
                            list.add(IncidentEventContext.Template.parse(parser));
                        }
                        catch (ElasticsearchParseException e) {
                            throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{XField.CONTEXT.getPreferredName()});
                        }
                    }
                    contexts = list.toArray(new IncidentEventContext.Template[list.size()]);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse pager duty event template. unexpected field [{}]", new Object[]{currentFieldName});
            }
            return new Template(description, eventType, incidentKey, client, clientUrl, account, attachPayload, contexts);
        }

        public static class Builder {
            final TextTemplate description;
            TextTemplate incidentKey;
            TextTemplate client;
            TextTemplate clientUrl;
            TextTemplate eventType;
            String account;
            Boolean attachPayload;
            List<IncidentEventContext.Template> contexts = new ArrayList<IncidentEventContext.Template>();

            public Builder(TextTemplate description) {
                this.description = description;
            }

            public Builder setIncidentKey(TextTemplate incidentKey) {
                this.incidentKey = incidentKey;
                return this;
            }

            public Builder setClient(TextTemplate client) {
                this.client = client;
                return this;
            }

            public Builder setClientUrl(TextTemplate clientUrl) {
                this.clientUrl = clientUrl;
                return this;
            }

            public Builder setEventType(TextTemplate eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder setAccount(String account) {
                this.account = account;
                return this;
            }

            public Builder setAttachPayload(Boolean attachPayload) {
                this.attachPayload = attachPayload;
                return this;
            }

            public Builder addContext(IncidentEventContext.Template context) {
                this.contexts.add(context);
                return this;
            }

            public Template build() {
                IncidentEventContext.Template[] contexts = this.contexts.isEmpty() ? null : this.contexts.toArray(new IncidentEventContext.Template[this.contexts.size()]);
                return new Template(this.description, this.eventType, this.incidentKey, this.client, this.clientUrl, this.account, this.attachPayload, contexts);
            }
        }
    }
}

