/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.pagerduty;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.hipchat.ExecutableHipChatAction;
import org.elasticsearch.watcher.actions.pagerduty.ExecutablePagerDutyAction;
import org.elasticsearch.watcher.actions.pagerduty.PagerDutyAction;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyAccount;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyService;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class PagerDutyActionFactory
extends ActionFactory<PagerDutyAction, ExecutablePagerDutyAction> {
    private final TextTemplateEngine templateEngine;
    private final PagerDutyService pagerDutyService;

    @Inject
    public PagerDutyActionFactory(Settings settings, TextTemplateEngine templateEngine, PagerDutyService pagerDutyService) {
        super(Loggers.getLogger(ExecutableHipChatAction.class, (Settings)settings, (String[])new String[0]));
        this.templateEngine = templateEngine;
        this.pagerDutyService = pagerDutyService;
    }

    @Override
    public String type() {
        return "pagerduty";
    }

    @Override
    public PagerDutyAction parseAction(String watchId, String actionId, XContentParser parser) throws IOException {
        PagerDutyAction action = PagerDutyAction.parse(watchId, actionId, parser);
        PagerDutyAccount account = this.pagerDutyService.getAccount(action.event.account);
        if (account == null) {
            throw new ElasticsearchParseException("could not parse [pagerduty] action [{}/{}]. unknown pager duty account [{}]", new Object[]{watchId, account, action.event.account});
        }
        return action;
    }

    @Override
    public ExecutablePagerDutyAction createExecutable(PagerDutyAction action) {
        return new ExecutablePagerDutyAction(action, this.actionLogger, this.pagerDutyService, this.templateEngine);
    }
}

