/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.pagerduty;

import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ExecutableAction;
import org.elasticsearch.watcher.actions.pagerduty.PagerDutyAction;
import org.elasticsearch.watcher.actions.pagerduty.service.IncidentEvent;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyAccount;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyService;
import org.elasticsearch.watcher.actions.pagerduty.service.SentEvent;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutablePagerDutyAction
extends ExecutableAction<PagerDutyAction> {
    private final TextTemplateEngine templateEngine;
    private final PagerDutyService pagerDutyService;

    public ExecutablePagerDutyAction(PagerDutyAction action, ESLogger logger, PagerDutyService pagerDutyService, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.pagerDutyService = pagerDutyService;
        this.templateEngine = templateEngine;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        PagerDutyAccount account;
        PagerDutyAccount pagerDutyAccount = account = ((PagerDutyAction)this.action).event.account != null ? this.pagerDutyService.getAccount(((PagerDutyAction)this.action).event.account) : this.pagerDutyService.getDefaultAccount();
        if (account == null) {
            throw new IllegalStateException("account [" + ((PagerDutyAction)this.action).event.account + "] was not found. perhaps it was deleted");
        }
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        IncidentEvent event = ((PagerDutyAction)this.action).event.render(ctx.watch().id(), actionId, this.templateEngine, model, account.getDefaults());
        if (ctx.simulateAction(actionId)) {
            return new PagerDutyAction.Result.Simulated(event);
        }
        SentEvent sentEvent = account.send(event, payload);
        return new PagerDutyAction.Result.Executed(account.getName(), sentEvent);
    }
}

