/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.logging;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.logging.ExecutableLoggingAction;
import org.elasticsearch.watcher.actions.logging.LoggingAction;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class LoggingActionFactory
extends ActionFactory<LoggingAction, ExecutableLoggingAction> {
    private final Settings settings;
    private final TextTemplateEngine templateEngine;

    @Inject
    public LoggingActionFactory(Settings settings, TextTemplateEngine templateEngine) {
        super(Loggers.getLogger(ExecutableLoggingAction.class, (Settings)settings, (String[])new String[0]));
        this.settings = settings;
        this.templateEngine = templateEngine;
    }

    @Override
    public String type() {
        return "logging";
    }

    @Override
    public LoggingAction parseAction(String watchId, String actionId, XContentParser parser) throws IOException {
        return LoggingAction.parse(watchId, actionId, parser);
    }

    @Override
    public ExecutableLoggingAction createExecutable(LoggingAction action) {
        return new ExecutableLoggingAction(action, this.actionLogger, this.settings, this.templateEngine);
    }
}

