/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.hipchat.service;

import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatAccount;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatAccounts;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatService;
import org.elasticsearch.watcher.shield.WatcherSettingsFilter;
import org.elasticsearch.watcher.support.http.HttpClient;

public class InternalHipChatService
extends AbstractLifecycleComponent<HipChatService>
implements HipChatService {
    private final HttpClient httpClient;
    private volatile HipChatAccounts accounts;

    @Inject
    public InternalHipChatService(Settings settings, HttpClient httpClient, NodeSettingsService nodeSettingsService, WatcherSettingsFilter settingsFilter) {
        super(settings);
        this.httpClient = httpClient;
        nodeSettingsService.addListener(new NodeSettingsService.Listener(){

            public void onRefreshSettings(Settings settings) {
                InternalHipChatService.this.reset(settings);
            }
        });
        settingsFilter.filterOut("watcher.actions.hipchat.service.account.*.auth_token");
    }

    protected void doStart() {
        this.reset(this.settings);
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    @Override
    public HipChatAccount getDefaultAccount() {
        return this.accounts.account(null);
    }

    @Override
    public HipChatAccount getAccount(String name) {
        return this.accounts.account(name);
    }

    void reset(Settings nodeSettings) {
        Settings.Builder builder = Settings.builder();
        String prefix = "watcher.actions.hipchat.service";
        for (String setting : this.settings.getAsMap().keySet()) {
            if (!setting.startsWith(prefix)) continue;
            builder.put(setting.substring(prefix.length() + 1), this.settings.get(setting));
        }
        if (nodeSettings != this.settings) {
            for (String setting : nodeSettings.getAsMap().keySet()) {
                if (!setting.startsWith(prefix)) continue;
                builder.put(setting.substring(prefix.length() + 1), nodeSettings.get(setting));
            }
        }
        this.accounts = new HipChatAccounts(builder.build(), this.httpClient, this.logger);
    }
}

