/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.email.service.attachment;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.email.service.Attachment;
import org.elasticsearch.watcher.actions.email.service.attachment.EmailAttachmentParser;
import org.elasticsearch.watcher.actions.email.service.attachment.HttpRequestAttachment;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.http.HttpClient;
import org.elasticsearch.watcher.support.http.HttpRequest;
import org.elasticsearch.watcher.support.http.HttpRequestTemplate;
import org.elasticsearch.watcher.support.http.HttpResponse;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;
import org.elasticsearch.watcher.watch.Payload;

public class HttpEmailAttachementParser
implements EmailAttachmentParser<HttpRequestAttachment> {
    public static final String TYPE = "http";
    private final HttpClient httpClient;
    private HttpRequestTemplate.Parser requestTemplateParser;
    private final TextTemplateEngine templateEngine;
    private final ESLogger logger;

    @Inject
    public HttpEmailAttachementParser(HttpClient httpClient, HttpRequestTemplate.Parser requestTemplateParser, TextTemplateEngine templateEngine) {
        this.httpClient = httpClient;
        this.requestTemplateParser = requestTemplateParser;
        this.templateEngine = templateEngine;
        this.logger = Loggers.getLogger(this.getClass());
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public HttpRequestAttachment parse(String id, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String contentType = null;
        HttpRequestTemplate requestTemplate = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.CONTENT_TYPE)) {
                contentType = parser.text();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.REQUEST)) {
                requestTemplate = this.requestTemplateParser.parse(parser);
                continue;
            }
            throw new ElasticsearchParseException("Unknown field name [" + currentFieldName + "] in http request attachment configuration", new Object[0]);
        }
        if (requestTemplate != null) {
            return new HttpRequestAttachment(id, requestTemplate, contentType);
        }
        throw new ElasticsearchParseException("Could not parse http request attachment", new Object[0]);
    }

    @Override
    public Attachment toAttachment(WatchExecutionContext context, Payload payload, HttpRequestAttachment attachment) throws ElasticsearchException {
        Map<String, Object> model = Variables.createCtxModel(context, payload);
        HttpRequest httpRequest = attachment.getRequestTemplate().render(this.templateEngine, model);
        try {
            HttpResponse response = this.httpClient.execute(httpRequest);
            if (response.status() >= 200 && response.status() < 300) {
                if (response.hasContent()) {
                    String contentType = attachment.getContentType();
                    String attachmentContentType = Strings.hasLength((String)contentType) ? contentType : response.contentType();
                    return new Attachment.Bytes(attachment.id(), response.body().toBytes(), attachmentContentType);
                }
                this.logger.error("Empty response body: [host[{}], port[{}], method[{}], path[{}]: response status [{}]", new Object[]{httpRequest.host(), httpRequest.port(), httpRequest.method(), httpRequest.path(), response.status()});
            } else {
                this.logger.error("Error getting http response: [host[{}], port[{}], method[{}], path[{}]: response status [{}]", new Object[]{httpRequest.host(), httpRequest.port(), httpRequest.method(), httpRequest.path(), response.status()});
            }
        }
        catch (IOException e) {
            this.logger.error("Error executing HTTP request: [host[{}], port[{}], method[{}], path[{}]: [{}]", (Throwable)e, new Object[]{httpRequest.port(), httpRequest.method(), httpRequest.path(), e.getMessage()});
        }
        throw new ElasticsearchException("Unable to get attachment of type [{}] with id [{}] in watch [{}] aborting watch execution", new Object[]{this.type(), attachment.id(), context.watch().id()});
    }

    public static interface Fields {
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField CONTENT_TYPE = new ParseField("content_type", new String[0]);
    }
}

