/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.email.service.attachment;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.email.service.Attachment;
import org.elasticsearch.watcher.actions.email.service.attachment.DataAttachment;
import org.elasticsearch.watcher.actions.email.service.attachment.EmailAttachmentParser;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.watch.Payload;

public class DataAttachmentParser
implements EmailAttachmentParser<DataAttachment> {
    public static final String TYPE = "data";

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public DataAttachment parse(String id, XContentParser parser) throws IOException {
        XContentParser.Token token;
        org.elasticsearch.watcher.actions.email.DataAttachment dataAttachment = org.elasticsearch.watcher.actions.email.DataAttachment.YAML;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!Strings.hasLength(currentFieldName) || !ParseFieldMatcher.STRICT.match(currentFieldName, Fields.FORMAT)) continue;
            if (token == XContentParser.Token.VALUE_STRING) {
                dataAttachment = org.elasticsearch.watcher.actions.email.DataAttachment.resolve(parser.text());
                continue;
            }
            throw new ElasticsearchParseException("could not parse data attachment. expected string value for [{}] field but found [{}] instead", new Object[]{currentFieldName, token});
        }
        return new DataAttachment(id, dataAttachment);
    }

    @Override
    public Attachment toAttachment(WatchExecutionContext ctx, Payload payload, DataAttachment attachment) {
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        return attachment.getDataAttachment().create(attachment.id(), model);
    }

    static interface Fields {
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
    }
}

