/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.email.service;

import javax.mail.MessagingException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.watcher.actions.email.service.Account;
import org.elasticsearch.watcher.actions.email.service.Accounts;
import org.elasticsearch.watcher.actions.email.service.Authentication;
import org.elasticsearch.watcher.actions.email.service.Email;
import org.elasticsearch.watcher.actions.email.service.EmailService;
import org.elasticsearch.watcher.actions.email.service.Profile;
import org.elasticsearch.watcher.shield.WatcherSettingsFilter;
import org.elasticsearch.watcher.support.secret.SecretService;

public class InternalEmailService
extends AbstractLifecycleComponent<EmailService>
implements EmailService {
    private final SecretService secretService;
    private volatile Accounts accounts;

    @Inject
    public InternalEmailService(Settings settings, SecretService secretService, NodeSettingsService nodeSettingsService, WatcherSettingsFilter settingsFilter) {
        super(settings);
        this.secretService = secretService;
        nodeSettingsService.addListener(new NodeSettingsService.Listener(){

            public void onRefreshSettings(Settings settings) {
                InternalEmailService.this.reset(settings);
            }
        });
        settingsFilter.filterOut("watcher.actions.email.service.account.*.smtp.password");
    }

    protected void doStart() throws ElasticsearchException {
        this.reset(this.settings);
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public EmailService.EmailSent send(Email email, Authentication auth, Profile profile) throws MessagingException {
        return this.send(email, auth, profile, (String)null);
    }

    @Override
    public EmailService.EmailSent send(Email email, Authentication auth, Profile profile, String accountName) throws MessagingException {
        Account account = this.accounts.account(accountName);
        if (account == null) {
            throw new IllegalArgumentException("failed to send email with subject [" + email.subject() + "] via account [" + accountName + "]. account does not exist");
        }
        return this.send(email, auth, profile, account);
    }

    EmailService.EmailSent send(Email email, Authentication auth, Profile profile, Account account) throws MessagingException {
        assert (account != null);
        try {
            email = account.send(email, auth, profile);
        }
        catch (MessagingException me) {
            throw new MessagingException("failed to send email with subject [" + email.subject() + "] via account [" + account.name() + "]", (Exception)((Object)me));
        }
        return new EmailService.EmailSent(account.name(), email);
    }

    void reset(Settings nodeSettings) {
        Settings.Builder builder = Settings.builder();
        String prefix = "watcher.actions.email.service";
        for (String setting : this.settings.getAsMap().keySet()) {
            if (!setting.startsWith(prefix)) continue;
            builder.put(setting.substring(prefix.length() + 1), this.settings.get(setting));
        }
        if (nodeSettings != this.settings) {
            for (String setting : nodeSettings.getAsMap().keySet()) {
                if (!setting.startsWith(prefix)) continue;
                builder.put(setting.substring(prefix.length() + 1), nodeSettings.get(setting));
            }
        }
        this.accounts = this.createAccounts(builder.build(), this.logger);
    }

    protected Accounts createAccounts(Settings settings, ESLogger logger) {
        return new Accounts(settings, this.secretService, logger);
    }
}

