/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.email.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.actions.email.service.support.BodyPartSource;

public abstract class Inline
extends BodyPartSource {
    protected Inline(String id, String name, String contentType) {
        super(id, name, contentType);
    }

    public abstract String type();

    @Override
    public final MimeBodyPart bodyPart() throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setDisposition("inline");
        part.setContentID(this.id);
        part.setFileName(this.name);
        this.writeTo(part);
        return part;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("type", this.type()).field("id", this.id).field("name", this.name).field("content_type", this.contentType).endObject();
    }

    protected abstract void writeTo(MimeBodyPart var1) throws MessagingException;

    public static class Bytes
    extends Stream {
        public Bytes(String id, String name, String contentType, byte[] bytes) {
            super(id, name, contentType, new BytesStreamProvider(bytes));
        }

        public Bytes(String id, String name, String contentType, BytesReference bytes) {
            super(id, name, contentType, new BytesStreamProvider(bytes));
        }

        static class BytesStreamProvider
        implements Provider<InputStream> {
            private final BytesReference bytes;

            public BytesStreamProvider(byte[] bytes) {
                this((BytesReference)new BytesArray(bytes));
            }

            public BytesStreamProvider(BytesReference bytes) {
                this.bytes = bytes;
            }

            public InputStream get() {
                return new ByteArrayInputStream(this.bytes.array(), this.bytes.arrayOffset(), this.bytes.length());
            }
        }
    }

    public static class Stream
    extends Inline {
        static final String TYPE = "stream";
        private final Provider<InputStream> source;

        public Stream(String id, String name, Provider<InputStream> source) {
            this(id, name, fileTypeMap.getContentType(name), source);
        }

        public Stream(String id, String name, String contentType, Provider<InputStream> source) {
            super(id, name, contentType);
            this.source = source;
        }

        @Override
        public String type() {
            return TYPE;
        }

        @Override
        protected void writeTo(MimeBodyPart part) throws MessagingException {
            StreamDataSource ds = new StreamDataSource(this.name, this.contentType, this.source);
            DataHandler dh = new DataHandler((DataSource)ds);
            part.setDataHandler(dh);
        }

        static class StreamDataSource
        implements DataSource {
            private final String name;
            private final String contentType;
            private final Provider<InputStream> source;

            public StreamDataSource(String name, String contentType, Provider<InputStream> source) {
                this.name = name;
                this.contentType = contentType;
                this.source = source;
            }

            public InputStream getInputStream() throws IOException {
                return (InputStream)this.source.get();
            }

            public OutputStream getOutputStream() throws IOException {
                throw new UnsupportedOperationException();
            }

            public String getContentType() {
                return this.contentType;
            }

            public String getName() {
                return this.name;
            }
        }
    }

    public static class File
    extends Inline {
        static final String TYPE = "file";
        private final Path path;
        private DataSource dataSource;

        public File(String id, Path path) {
            this(id, path.getFileName().toString(), path);
        }

        @SuppressForbidden(reason="uses toFile")
        public File(String id, String name, Path path) {
            this(id, name, path, fileTypeMap.getContentType(path.toFile()));
        }

        @SuppressForbidden(reason="uses toFile")
        public File(String id, String name, Path path, String contentType) {
            super(id, name, contentType);
            this.path = path;
            this.dataSource = new FileDataSource(path.toFile());
        }

        public Path path() {
            return this.path;
        }

        @Override
        public String type() {
            return TYPE;
        }

        @Override
        public void writeTo(MimeBodyPart part) throws MessagingException {
            part.setDataHandler(new DataHandler((Object)this.dataSource, this.contentType));
        }
    }
}

