/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.shield.authz.AuthorizationModule;
import org.elasticsearch.watcher.WatcherMetaData;
import org.elasticsearch.watcher.WatcherModule;
import org.elasticsearch.watcher.actions.WatcherActionModule;
import org.elasticsearch.watcher.actions.email.service.EmailService;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatService;
import org.elasticsearch.watcher.actions.pagerduty.service.PagerDutyService;
import org.elasticsearch.watcher.actions.slack.service.SlackService;
import org.elasticsearch.watcher.client.WatcherClientModule;
import org.elasticsearch.watcher.condition.ConditionModule;
import org.elasticsearch.watcher.execution.ExecutionModule;
import org.elasticsearch.watcher.history.HistoryModule;
import org.elasticsearch.watcher.history.HistoryStore;
import org.elasticsearch.watcher.input.InputModule;
import org.elasticsearch.watcher.license.LicenseModule;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.rest.action.RestAckWatchAction;
import org.elasticsearch.watcher.rest.action.RestActivateWatchAction;
import org.elasticsearch.watcher.rest.action.RestDeleteWatchAction;
import org.elasticsearch.watcher.rest.action.RestExecuteWatchAction;
import org.elasticsearch.watcher.rest.action.RestGetWatchAction;
import org.elasticsearch.watcher.rest.action.RestHijackOperationAction;
import org.elasticsearch.watcher.rest.action.RestPutWatchAction;
import org.elasticsearch.watcher.rest.action.RestWatchServiceAction;
import org.elasticsearch.watcher.rest.action.RestWatcherInfoAction;
import org.elasticsearch.watcher.rest.action.RestWatcherStatsAction;
import org.elasticsearch.watcher.shield.ShieldIntegration;
import org.elasticsearch.watcher.shield.WatcherShieldModule;
import org.elasticsearch.watcher.shield.WatcherUserHolder;
import org.elasticsearch.watcher.support.WatcherIndexTemplateRegistry;
import org.elasticsearch.watcher.support.clock.ClockModule;
import org.elasticsearch.watcher.support.http.HttpClient;
import org.elasticsearch.watcher.support.http.HttpClientModule;
import org.elasticsearch.watcher.support.init.InitializingModule;
import org.elasticsearch.watcher.support.init.InitializingService;
import org.elasticsearch.watcher.support.init.proxy.ScriptServiceProxy;
import org.elasticsearch.watcher.support.secret.SecretModule;
import org.elasticsearch.watcher.support.text.TextTemplateModule;
import org.elasticsearch.watcher.support.validation.WatcherSettingsValidation;
import org.elasticsearch.watcher.transform.TransformModule;
import org.elasticsearch.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.watcher.transport.actions.ack.TransportAckWatchAction;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.watcher.transport.actions.activate.TransportActivateWatchAction;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.watcher.transport.actions.delete.TransportDeleteWatchAction;
import org.elasticsearch.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.watcher.transport.actions.execute.TransportExecuteWatchAction;
import org.elasticsearch.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.watcher.transport.actions.get.TransportGetWatchAction;
import org.elasticsearch.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.watcher.transport.actions.put.TransportPutWatchAction;
import org.elasticsearch.watcher.transport.actions.service.TransportWatcherServiceAction;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.watcher.transport.actions.stats.TransportWatcherStatsAction;
import org.elasticsearch.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.watcher.trigger.TriggerModule;
import org.elasticsearch.watcher.trigger.schedule.ScheduleModule;
import org.elasticsearch.watcher.watch.WatchModule;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class WatcherPlugin
extends Plugin {
    public static final String NAME = "watcher";
    public static final String ENABLED_SETTING = "watcher.enabled";
    private static final ESLogger logger = Loggers.getLogger(WatcherPlugin.class);
    protected final Settings settings;
    protected final boolean transportClient;
    protected final boolean enabled;

    public WatcherPlugin(Settings settings) {
        this.settings = settings;
        this.transportClient = "transport".equals(settings.get("client.type"));
        this.enabled = WatcherPlugin.watcherEnabled(settings);
        WatcherPlugin.validAutoCreateIndex(settings);
    }

    public String name() {
        return NAME;
    }

    public String description() {
        return "Elasticsearch Watcher";
    }

    public Collection<Module> nodeModules() {
        if (!this.enabled || this.transportClient) {
            return Collections.emptyList();
        }
        return Arrays.asList(new Module[]{new WatcherModule(this.settings), new InitializingModule(), new LicenseModule(), new WatchModule(), new TextTemplateModule(), new HttpClientModule(), new ClockModule(), new WatcherClientModule(), new TransformModule(), new TriggerModule(this.settings), new ScheduleModule(), new ConditionModule(), new InputModule(), new WatcherActionModule(), new HistoryModule(), new ExecutionModule(), new WatcherShieldModule(this.settings), new SecretModule(this.settings)});
    }

    public Collection<Class<? extends LifecycleComponent>> nodeServices() {
        if (!this.enabled || this.transportClient) {
            return Collections.emptyList();
        }
        return Arrays.asList(InitializingService.class, WatcherLicensee.class, EmailService.class, HipChatService.class, SlackService.class, PagerDutyService.class, HttpClient.class, WatcherSettingsValidation.class);
    }

    public Settings additionalSettings() {
        if (!this.enabled || this.transportClient) {
            return Settings.EMPTY;
        }
        Settings additionalSettings = Settings.settingsBuilder().put(HistoryModule.additionalSettings(this.settings)).build();
        return additionalSettings;
    }

    public void onModule(ScriptModule module) {
        module.registerScriptContext(ScriptServiceProxy.INSTANCE);
    }

    public void onModule(ClusterModule module) {
        for (WatcherIndexTemplateRegistry.TemplateConfig templateConfig : WatcherModule.TEMPLATE_CONFIGS) {
            module.registerClusterDynamicSetting(templateConfig.getDynamicSettingsPrefix(), Validator.EMPTY);
        }
    }

    public void onModule(RestModule module) {
        if (this.enabled && !this.transportClient) {
            module.addRestAction(RestPutWatchAction.class);
            module.addRestAction(RestDeleteWatchAction.class);
            module.addRestAction(RestWatcherStatsAction.class);
            module.addRestAction(RestWatcherInfoAction.class);
            module.addRestAction(RestGetWatchAction.class);
            module.addRestAction(RestWatchServiceAction.class);
            module.addRestAction(RestAckWatchAction.class);
            module.addRestAction(RestActivateWatchAction.class);
            module.addRestAction(RestExecuteWatchAction.class);
            module.addRestAction(RestHijackOperationAction.class);
        }
    }

    public void onModule(ActionModule module) {
        if (this.enabled) {
            module.registerAction((GenericAction)PutWatchAction.INSTANCE, TransportPutWatchAction.class, new Class[0]);
            module.registerAction((GenericAction)DeleteWatchAction.INSTANCE, TransportDeleteWatchAction.class, new Class[0]);
            module.registerAction((GenericAction)GetWatchAction.INSTANCE, TransportGetWatchAction.class, new Class[0]);
            module.registerAction((GenericAction)WatcherStatsAction.INSTANCE, TransportWatcherStatsAction.class, new Class[0]);
            module.registerAction((GenericAction)AckWatchAction.INSTANCE, TransportAckWatchAction.class, new Class[0]);
            module.registerAction((GenericAction)ActivateWatchAction.INSTANCE, TransportActivateWatchAction.class, new Class[0]);
            module.registerAction((GenericAction)WatcherServiceAction.INSTANCE, TransportWatcherServiceAction.class, new Class[0]);
            module.registerAction((GenericAction)ExecuteWatchAction.INSTANCE, TransportExecuteWatchAction.class, new Class[0]);
        }
    }

    public void onModule(Module module) {
        if (this.enabled && ShieldIntegration.enabled(this.settings) && module instanceof AuthorizationModule) {
            ((AuthorizationModule)module).registerReservedRole(WatcherUserHolder.ROLE);
        }
    }

    public static boolean watcherEnabled(Settings settings) {
        return settings.getAsBoolean(ENABLED_SETTING, Boolean.valueOf(true));
    }

    static void validAutoCreateIndex(Settings settings) {
        String value = settings.get("action.auto_create_index");
        if (value == null) {
            return;
        }
        String errorMessage = LoggerMessageFormat.format((String)"the [action.auto_create_index] setting value [{}] is too restrictive. disable [action.auto_create_index] or set it to [{}, {}, {}*]", (Object[])new Object[]{value, ".watches", ".triggered_watches", ".watch_history-"});
        if (Booleans.isExplicitFalse((String)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (Booleans.isExplicitTrue((String)value)) {
            return;
        }
        String[] matches = Strings.commaDelimitedListToStringArray((String)value);
        ArrayList<String> indices = new ArrayList<String>();
        indices.add(".watches");
        indices.add(".triggered_watches");
        DateTime now = new DateTime(DateTimeZone.UTC);
        indices.add(HistoryStore.getHistoryIndexNameForTime(now));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusDays(1)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(1)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(2)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(3)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(4)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(5)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(6)));
        for (String index : indices) {
            boolean matched = false;
            for (String match : matches) {
                char c = match.charAt(0);
                if (c == '-') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    throw new IllegalArgumentException(errorMessage);
                }
                if (c == '+') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    matched = true;
                    break;
                }
                if (!Regex.simpleMatch((String)match, (String)index)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            throw new IllegalArgumentException(errorMessage);
        }
        logger.warn("the [action.auto_create_index] setting is configured to be restrictive [{}]. for the next 6 months daily history indices are allowed to be created, but please make sure that any future history indices after 6 months with the pattern [.watch_history-YYYY.MM.dd] are allowed to be created", new Object[]{value});
    }

    static {
        MetaData.registerPrototype((String)NAME, (MetaData.Custom)WatcherMetaData.PROTO);
    }
}

