/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.watch;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.support.concurrent.FairKeyedLock;
import org.joda.time.PeriodType;

public class WatchLockService
extends AbstractComponent {
    private final FairKeyedLock<String> watchLocks = new FairKeyedLock();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private static final TimeValue DEFAULT_MAX_STOP_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);
    private static final String DEFAULT_MAX_STOP_TIMEOUT_SETTING = "watcher.stop.timeout";
    private final TimeValue maxStopTimeout;

    @Inject
    public WatchLockService(Settings settings) {
        super(settings);
        this.maxStopTimeout = settings.getAsTime(DEFAULT_MAX_STOP_TIMEOUT_SETTING, DEFAULT_MAX_STOP_TIMEOUT);
    }

    WatchLockService(TimeValue maxStopTimeout) {
        super(Settings.EMPTY);
        this.maxStopTimeout = maxStopTimeout;
    }

    public Lock acquire(String name) {
        if (!this.running.get()) {
            throw Exceptions.illegalState("cannot acquire lock for watch [{}]. lock service is not running", name);
        }
        this.watchLocks.acquire(name);
        return new Lock(name, this.watchLocks);
    }

    public Lock tryAcquire(String name, TimeValue timeout) {
        if (!this.running.get()) {
            throw Exceptions.illegalState("cannot acquire lock for watch [{}]. lock service is not running", name);
        }
        try {
            if (!this.watchLocks.tryAcquire(name, timeout.millis(), TimeUnit.MILLISECONDS)) {
                this.logger.warn("failed to acquire lock on watch [{}] (waited for [{}]). It is possible that for some reason this watch execution is stuck", new Object[]{name, timeout.format(PeriodType.seconds())});
                return null;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.logger.error("could not acquire lock for watch [{}]", (Throwable)ie, new Object[]{name});
            return null;
        }
        return new Lock(name, this.watchLocks);
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            // empty if block
        }
    }

    public void stop() throws ElasticsearchTimeoutException {
        if (this.running.compareAndSet(true, false)) {
            long startWait = System.currentTimeMillis();
            while (this.watchLocks.hasLockedKeys()) {
                TimeValue timeWaiting = new TimeValue(System.currentTimeMillis() - startWait);
                if (timeWaiting.getSeconds() > this.maxStopTimeout.getSeconds()) {
                    throw new ElasticsearchTimeoutException("timed out waiting for watches to complete, after waiting for [{}]", new Object[]{timeWaiting});
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    FairKeyedLock<String> getWatchLocks() {
        return this.watchLocks;
    }

    public static class Lock {
        private final String name;
        private final FairKeyedLock<String> watchLocks;

        private Lock(String name, FairKeyedLock<String> watchLocks) {
            this.name = name;
            this.watchLocks = watchLocks;
        }

        public void release() {
            this.watchLocks.release(this.name);
        }
    }
}

