/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger.schedule.tool;

import org.apache.commons.cli.CommandLine;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.cli.CliTool;
import org.elasticsearch.common.cli.CliToolConfig;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.trigger.schedule.Cron;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CronEvalTool
extends CliTool {
    private static final CliToolConfig CONFIG = CliToolConfig.config((String)"croneval", CronEvalTool.class).cmds(new CliToolConfig.Cmd[]{Eval.access$000()}).build();

    public static void main(String[] args) throws Exception {
        CliTool.ExitStatus exitStatus = new CronEvalTool().execute(args);
        CronEvalTool.exit(exitStatus.status());
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    private static void exit(int status) {
        System.exit(status);
    }

    public CronEvalTool() {
        super(CONFIG);
    }

    protected CliTool.Command parse(String s, CommandLine cli) throws Exception {
        return Eval.parse(this.terminal, cli);
    }

    static class Eval
    extends CliTool.Command {
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"eval", Eval.class).options(new CliToolConfig.OptionBuilder[]{CliToolConfig.Builder.option((String)"c", (String)"count").hasArg(false).required(false)}).build();
        private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"EEE, d MMM yyyy HH:mm:ss");
        final String expression;
        final int count;

        Eval(Terminal terminal, String expression, int count) {
            super(terminal);
            this.expression = expression;
            this.count = count;
        }

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            String[] args = cli.getArgs();
            if (args.length != 1) {
                return CronEvalTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"expecting a single argument that is the cron expression to evaluate", (Object[])new Object[0]);
            }
            String count = cli.getOptionValue("count", "10");
            try {
                return new Eval(terminal, args[0], Integer.parseInt(count));
            }
            catch (NumberFormatException nfe) {
                return CronEvalTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"passed in count [%s] cannot be converted to a number", (Object[])new Object[]{count});
            }
        }

        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            Cron.validate(this.expression);
            this.terminal.println("Valid!", new Object[0]);
            DateTime date = DateTime.now((DateTimeZone)DateTimeZone.UTC);
            this.terminal.println("Now is [" + formatter.print((ReadableInstant)date) + "]", new Object[0]);
            this.terminal.println("Here are the next " + this.count + " times this cron expression will trigger:", new Object[0]);
            Cron cron = new Cron(this.expression);
            long time = date.getMillis();
            for (int i = 0; i < this.count; ++i) {
                long prevTime = time;
                if ((time = cron.getNextValidTimeAfter(time)) < 0L) {
                    this.terminal.printError(i + 1 + ".\t Could not compute future times since [" + formatter.print(prevTime) + "] " + "(perhaps the cron expression only points to times in the past?)", new Object[0]);
                    return CliTool.ExitStatus.OK;
                }
                this.terminal.println(i + 1 + ".\t" + formatter.print(time), new Object[0]);
            }
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$000() {
            return CMD;
        }
    }
}

