/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger.schedule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.trigger.schedule.CronnableSchedule;
import org.elasticsearch.watcher.trigger.schedule.Schedule;
import org.elasticsearch.watcher.trigger.schedule.support.WeekTimes;

public class WeeklySchedule
extends CronnableSchedule {
    public static final String TYPE = "weekly";
    public static final WeekTimes[] DEFAULT_TIMES = new WeekTimes[]{new WeekTimes()};
    private final WeekTimes[] times;

    WeeklySchedule() {
        this(DEFAULT_TIMES);
    }

    WeeklySchedule(WeekTimes ... times) {
        super(WeeklySchedule.crons(times));
        this.times = times;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public WeekTimes[] times() {
        return this.times;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (params.paramAsBoolean("normalize", false) && this.times.length == 1) {
            return this.times[0].toXContent(builder, params);
        }
        builder.startArray();
        for (WeekTimes weekTimes : this.times) {
            weekTimes.toXContent(builder, params);
        }
        return builder.endArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    static String[] crons(WeekTimes[] times) {
        assert (times.length > 0) : "at least one time must be defined";
        ArrayList<String> crons = new ArrayList<String>(times.length);
        for (WeekTimes time : times) {
            crons.addAll(time.crons());
        }
        return crons.toArray(new String[crons.size()]);
    }

    public static class Builder {
        private final Set<WeekTimes> times = new HashSet<WeekTimes>();

        public Builder time(WeekTimes time) {
            this.times.add(time);
            return this;
        }

        public Builder time(WeekTimes.Builder time) {
            return this.time(time.build());
        }

        public WeeklySchedule build() {
            return this.times.isEmpty() ? new WeeklySchedule() : new WeeklySchedule(this.times.toArray(new WeekTimes[this.times.size()]));
        }
    }

    public static class Parser
    implements Schedule.Parser<WeeklySchedule> {
        @Override
        public String type() {
            return WeeklySchedule.TYPE;
        }

        @Override
        public WeeklySchedule parse(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                try {
                    return new WeeklySchedule(WeekTimes.parse(parser, parser.currentToken()));
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse [{}] schedule. invalid weekly times", (Throwable)pe, new Object[]{WeeklySchedule.TYPE});
                }
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token;
                ArrayList<WeekTimes> times = new ArrayList<WeekTimes>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    try {
                        times.add(WeekTimes.parse(parser, token));
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse [{}] schedule. invalid weekly times", (Throwable)pe, new Object[]{WeeklySchedule.TYPE});
                    }
                }
                return times.isEmpty() ? new WeeklySchedule() : new WeeklySchedule(times.toArray(new WeekTimes[times.size()]));
            }
            throw new ElasticsearchParseException("could not parse [{}] schedule. expected either an object or an array of objects representing weekly times, but found [{}] instead", new Object[]{WeeklySchedule.TYPE, parser.currentToken()});
        }
    }
}

