/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger.schedule;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.trigger.TriggerEngine;
import org.elasticsearch.watcher.trigger.schedule.CronSchedule;
import org.elasticsearch.watcher.trigger.schedule.DailySchedule;
import org.elasticsearch.watcher.trigger.schedule.HourlySchedule;
import org.elasticsearch.watcher.trigger.schedule.IntervalSchedule;
import org.elasticsearch.watcher.trigger.schedule.MonthlySchedule;
import org.elasticsearch.watcher.trigger.schedule.Schedule;
import org.elasticsearch.watcher.trigger.schedule.ScheduleRegistry;
import org.elasticsearch.watcher.trigger.schedule.WeeklySchedule;
import org.elasticsearch.watcher.trigger.schedule.YearlySchedule;
import org.elasticsearch.watcher.trigger.schedule.engine.SchedulerScheduleTriggerEngine;
import org.elasticsearch.watcher.trigger.schedule.engine.TickerScheduleTriggerEngine;

public class ScheduleModule
extends AbstractModule {
    private final Map<String, Class<? extends Schedule.Parser>> parsers = new HashMap<String, Class<? extends Schedule.Parser>>();

    public ScheduleModule() {
        this.registerScheduleParser("cron", CronSchedule.Parser.class);
        this.registerScheduleParser("daily", DailySchedule.Parser.class);
        this.registerScheduleParser("hourly", HourlySchedule.Parser.class);
        this.registerScheduleParser("interval", IntervalSchedule.Parser.class);
        this.registerScheduleParser("monthly", MonthlySchedule.Parser.class);
        this.registerScheduleParser("weekly", WeeklySchedule.Parser.class);
        this.registerScheduleParser("yearly", YearlySchedule.Parser.class);
    }

    public static Class<? extends TriggerEngine> triggerEngineType(Settings nodeSettings) {
        Engine engine = Engine.resolve(nodeSettings);
        Loggers.getLogger(ScheduleModule.class, (Settings)nodeSettings, (String[])new String[0]).info("using [{}] schedule trigger engine", new Object[]{engine.name().toLowerCase(Locale.ROOT)});
        return engine.engineType();
    }

    public void registerScheduleParser(String parserType, Class<? extends Schedule.Parser> parserClass) {
        this.parsers.put(parserType, parserClass);
    }

    protected void configure() {
        MapBinder mbinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Schedule.Parser.class);
        for (Map.Entry<String, Class<? extends Schedule.Parser>> entry : this.parsers.entrySet()) {
            this.bind(entry.getValue()).asEagerSingleton();
            mbinder.addBinding((Object)entry.getKey()).to(entry.getValue());
        }
        this.bind(ScheduleRegistry.class).asEagerSingleton();
    }

    public static enum Engine {
        SCHEDULER{

            @Override
            protected Class<? extends TriggerEngine> engineType() {
                return SchedulerScheduleTriggerEngine.class;
            }
        }
        ,
        TICKER{

            @Override
            protected Class<? extends TriggerEngine> engineType() {
                return TickerScheduleTriggerEngine.class;
            }
        };


        protected abstract Class<? extends TriggerEngine> engineType();

        public static Engine resolve(Settings settings) {
            String engine = settings.get("watcher.trigger.schedule.engine", "ticker");
            switch (engine.toLowerCase(Locale.ROOT)) {
                case "ticker": {
                    return TICKER;
                }
                case "scheduler": {
                    return SCHEDULER;
                }
            }
            return TICKER;
        }
    }
}

