/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger.schedule;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.trigger.schedule.Schedule;

public class IntervalSchedule
implements Schedule {
    public static final String TYPE = "interval";
    private final Interval interval;

    public IntervalSchedule(Interval interval) {
        if (interval.millis < 1000L) {
            throw Exceptions.illegalArgument("interval can't be lower than 1000 ms, but [{}] was specified", interval);
        }
        this.interval = interval;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public long nextScheduledTimeAfter(long startTime, long time) {
        assert (time >= startTime);
        if (startTime == time) {
            ++time;
        }
        long delta = time - startTime;
        return startTime + (delta / this.interval.millis + 1L) * this.interval.millis;
    }

    public Interval interval() {
        return this.interval;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.interval.toXContent(builder, params);
    }

    public String toString() {
        return this.interval.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalSchedule schedule = (IntervalSchedule)o;
        return this.interval.equals(schedule.interval);
    }

    public int hashCode() {
        return this.interval.hashCode();
    }

    public static class Interval
    implements ToXContent {
        private final long duration;
        private final Unit unit;
        private final long millis;

        public Interval(long duration, Unit unit) {
            this.duration = duration;
            this.unit = unit;
            this.millis = unit.millis(duration);
        }

        public long seconds() {
            return this.unit.millis(this.duration) / Unit.SECONDS.millis;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.unit.format(this.duration));
        }

        public String toString() {
            return this.unit.format(this.duration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interval interval = (Interval)o;
            return this.unit.millis(this.duration) == interval.unit.millis(interval.duration);
        }

        public int hashCode() {
            long millis = this.unit.millis(this.duration);
            int result = (int)(millis ^ millis >>> 32);
            return result;
        }

        public static Interval seconds(long duration) {
            return new Interval(duration, Unit.SECONDS);
        }

        public static Interval parse(String value) {
            for (Unit unit : Unit.values()) {
                if (!value.endsWith(unit.suffix)) continue;
                return new Interval(unit.parse(value), unit);
            }
            throw Exceptions.illegalArgument("could not parse [{}] schedule. unrecognized interval format [{}]", IntervalSchedule.TYPE, value);
        }

        public static final class Unit
        extends Enum<Unit> {
            public static final /* enum */ Unit SECONDS = new Unit(TimeUnit.SECONDS.toMillis(1L), "s");
            public static final /* enum */ Unit MINUTES = new Unit(TimeUnit.MINUTES.toMillis(1L), "m");
            public static final /* enum */ Unit HOURS = new Unit(TimeUnit.HOURS.toMillis(1L), "h");
            public static final /* enum */ Unit DAYS = new Unit(TimeUnit.DAYS.toMillis(1L), "d");
            public static final /* enum */ Unit WEEK = new Unit(TimeUnit.DAYS.toMillis(7L), "w");
            private final String suffix;
            private final long millis;
            private static final /* synthetic */ Unit[] $VALUES;

            public static Unit[] values() {
                return (Unit[])$VALUES.clone();
            }

            public static Unit valueOf(String name) {
                return Enum.valueOf(Unit.class, name);
            }

            private Unit(long millis, String suffix) {
                this.millis = millis;
                this.suffix = suffix;
            }

            public long millis(long duration) {
                return duration * this.millis;
            }

            public long parse(String value) {
                assert (value.endsWith(this.suffix));
                String num = value.substring(0, value.indexOf(this.suffix));
                try {
                    return Long.parseLong(num);
                }
                catch (NumberFormatException nfe) {
                    throw new ElasticsearchParseException("could not parse [{}] schedule. could not parse [{}] as a [{}] duration", new Object[]{IntervalSchedule.TYPE, num, this.name().toLowerCase(Locale.ROOT)});
                }
            }

            public String format(long duration) {
                return duration + this.suffix;
            }

            static {
                $VALUES = new Unit[]{SECONDS, MINUTES, HOURS, DAYS, WEEK};
            }
        }
    }

    public static class Parser
    implements Schedule.Parser<IntervalSchedule> {
        @Override
        public String type() {
            return IntervalSchedule.TYPE;
        }

        @Override
        public IntervalSchedule parse(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            try {
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    return new IntervalSchedule(Interval.seconds(parser.longValue()));
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    String value = parser.text();
                    return new IntervalSchedule(Interval.parse(value));
                }
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("could not parse [{}] shcedule", (Throwable)e, new Object[0]);
            }
            throw new ElasticsearchParseException("could not parse [{}] schedule. expected either a numeric value (millis) or a string value representing time value (e.g. '5s'), but found [{}]", new Object[]{IntervalSchedule.TYPE, token});
        }
    }
}

