/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.joda.time.DateTime;

public abstract class TriggerEvent
implements ToXContent {
    private final String jobName;
    protected final DateTime triggeredTime;
    protected final Map<String, Object> data;

    public TriggerEvent(String jobName, DateTime triggeredTime) {
        this.jobName = jobName;
        this.triggeredTime = triggeredTime;
        this.data = new HashMap<String, Object>();
        this.data.put(Field.TRIGGERED_TIME.getPreferredName(), triggeredTime);
    }

    public String jobName() {
        return this.jobName;
    }

    public abstract String type();

    public DateTime triggeredTime() {
        return this.triggeredTime;
    }

    public final Map<String, Object> data() {
        return this.data;
    }

    public String toString() {
        return "[" + "name=[" + this.jobName + "]," + "triggered_time=[" + this.triggeredTime + "]," + "data=[" + this.data + "]" + "]";
    }

    public void recordXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.TYPE.getPreferredName(), this.type());
        WatcherDateTimeUtils.writeDate(Field.TRIGGERED_TIME.getPreferredName(), builder, this.triggeredTime);
        this.recordDataXContent(builder, params);
        builder.endObject();
    }

    public abstract void recordDataXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    protected static interface Field {
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField TRIGGERED_TIME = new ParseField("triggered_time", new String[0]);
    }
}

