/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.service;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.WatcherLifeCycleService;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceResponse;

public class TransportWatcherServiceAction
extends WatcherTransportAction<WatcherServiceRequest, WatcherServiceResponse> {
    private final WatcherLifeCycleService lifeCycleService;

    @Inject
    public TransportWatcherServiceAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherLifeCycleService lifeCycleService, WatcherLicensee watcherLicensee) {
        super(settings, "cluster:admin/watcher/service", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, watcherLicensee, WatcherServiceRequest.class);
        this.lifeCycleService = lifeCycleService;
    }

    protected String executor() {
        return "management";
    }

    protected WatcherServiceResponse newResponse() {
        return new WatcherServiceResponse();
    }

    protected void masterOperation(WatcherServiceRequest request, ClusterState state, ActionListener<WatcherServiceResponse> listener) throws ElasticsearchException {
        switch (request.getCommand()) {
            case START: {
                this.lifeCycleService.start();
                break;
            }
            case STOP: {
                this.lifeCycleService.stop();
                break;
            }
            case RESTART: {
                this.lifeCycleService.stop();
                this.lifeCycleService.start();
                break;
            }
            default: {
                listener.onFailure((Throwable)new IllegalArgumentException("Command [" + (Object)((Object)request.getCommand()) + "] is undefined"));
                return;
            }
        }
        listener.onResponse((Object)new WatcherServiceResponse(true));
    }

    protected ClusterBlockException checkBlock(WatcherServiceRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

