/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.get;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.plugin.core.LicenseUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.WatcherService;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.watcher.watch.Watch;

public class TransportGetWatchAction
extends WatcherTransportAction<GetWatchRequest, GetWatchResponse> {
    private final WatcherService watcherService;

    @Inject
    public TransportGetWatchAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, WatcherLicensee watcherLicensee) {
        super(settings, "cluster:monitor/watcher/watch/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, watcherLicensee, GetWatchRequest.class);
        this.watcherService = watcherService;
    }

    protected String executor() {
        return "same";
    }

    protected GetWatchResponse newResponse() {
        return new GetWatchResponse();
    }

    protected void masterOperation(GetWatchRequest request, ClusterState state, ActionListener<GetWatchResponse> listener) throws ElasticsearchException {
        if (!this.watcherLicensee.isGetWatchAllowed()) {
            listener.onFailure((Throwable)LicenseUtils.newComplianceException((String)"watcher"));
            return;
        }
        try {
            Watch watch = this.watcherService.getWatch(request.getId());
            if (watch == null) {
                listener.onResponse((Object)new GetWatchResponse(request.getId()));
                return;
            }
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                watch.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).build());
                BytesReference watchSource = builder.bytes();
                listener.onResponse((Object)new GetWatchResponse(watch.id(), watch.status(), watchSource, XContentType.JSON));
            }
            catch (IOException e) {
                listener.onFailure((Throwable)e);
            }
        }
        catch (Throwable t) {
            this.logger.error("failed to get watch [{}]", t, new Object[]{request.getId()});
            throw t;
        }
    }

    protected ClusterBlockException checkBlock(GetWatchRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, ".watches");
    }
}

