/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.get;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.watcher.support.xcontent.XContentSource;
import org.elasticsearch.watcher.watch.WatchStatus;

public class GetWatchResponse
extends ActionResponse {
    private String id;
    private WatchStatus status;
    private boolean found = false;
    private XContentSource source;

    GetWatchResponse() {
    }

    public GetWatchResponse(String id) {
        this.id = id;
        this.found = false;
        this.source = null;
    }

    public GetWatchResponse(String id, WatchStatus status, BytesReference source, XContentType contentType) {
        this.id = id;
        this.status = status;
        this.found = true;
        this.source = new XContentSource(source, contentType);
    }

    public String getId() {
        return this.id;
    }

    public WatchStatus getStatus() {
        return this.status;
    }

    public boolean isFound() {
        return this.found;
    }

    public XContentSource getSource() {
        return this.source;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.found = in.readBoolean();
        if (this.found) {
            this.status = WatchStatus.read(in);
            this.source = XContentSource.readFrom(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBoolean(this.found);
        if (this.found) {
            this.status.writeTo(out);
            XContentSource.writeTo(this.source, out);
        }
    }
}

