/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.activate;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.WatcherService;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.watcher.watch.WatchStatus;

public class TransportActivateWatchAction
extends WatcherTransportAction<ActivateWatchRequest, ActivateWatchResponse> {
    private final WatcherService watcherService;

    @Inject
    public TransportActivateWatchAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, WatcherLicensee watcherLicensee) {
        super(settings, "cluster:admin/watcher/watch/activate", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, watcherLicensee, ActivateWatchRequest.class);
        this.watcherService = watcherService;
    }

    protected String executor() {
        return "management";
    }

    protected ActivateWatchResponse newResponse() {
        return new ActivateWatchResponse();
    }

    protected void masterOperation(ActivateWatchRequest request, ClusterState state, ActionListener<ActivateWatchResponse> listener) throws ElasticsearchException {
        try {
            WatchStatus watchStatus = request.isActivate() ? this.watcherService.activateWatch(request.getWatchId(), request.masterNodeTimeout()) : this.watcherService.deactivateWatch(request.getWatchId(), request.masterNodeTimeout());
            ActivateWatchResponse response = new ActivateWatchResponse(watchStatus);
            listener.onResponse((Object)response);
        }
        catch (Exception e) {
            listener.onFailure((Throwable)e);
        }
    }

    protected ClusterBlockException checkBlock(ActivateWatchRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, ".watches");
    }
}

