/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.ack;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.WatcherService;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.watcher.watch.WatchStatus;

public class TransportAckWatchAction
extends WatcherTransportAction<AckWatchRequest, AckWatchResponse> {
    private final WatcherService watcherService;

    @Inject
    public TransportAckWatchAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, WatcherLicensee watcherLicensee) {
        super(settings, "cluster:admin/watcher/watch/ack", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, watcherLicensee, AckWatchRequest.class);
        this.watcherService = watcherService;
    }

    protected String executor() {
        return "management";
    }

    protected AckWatchResponse newResponse() {
        return new AckWatchResponse();
    }

    protected void masterOperation(AckWatchRequest request, ClusterState state, ActionListener<AckWatchResponse> listener) throws ElasticsearchException {
        try {
            WatchStatus watchStatus = this.watcherService.ackWatch(request.getWatchId(), request.getActionIds(), request.masterNodeTimeout());
            AckWatchResponse response = new AckWatchResponse(watchStatus);
            listener.onResponse((Object)response);
        }
        catch (Exception e) {
            listener.onFailure((Throwable)e);
        }
    }

    protected ClusterBlockException checkBlock(AckWatchRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, ".watches");
    }
}

