/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform.script;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.init.proxy.ScriptServiceProxy;
import org.elasticsearch.watcher.transform.TransformFactory;
import org.elasticsearch.watcher.transform.script.ExecutableScriptTransform;
import org.elasticsearch.watcher.transform.script.ScriptTransform;

public class ScriptTransformFactory
extends TransformFactory<ScriptTransform, ScriptTransform.Result, ExecutableScriptTransform> {
    private final ScriptServiceProxy scriptService;

    @Inject
    public ScriptTransformFactory(Settings settings, ScriptServiceProxy scriptService) {
        super(Loggers.getLogger(ExecutableScriptTransform.class, (Settings)settings, (String[])new String[0]));
        this.scriptService = scriptService;
    }

    @Override
    public String type() {
        return "script";
    }

    @Override
    public ScriptTransform parseTransform(String watchId, XContentParser parser) throws IOException {
        return ScriptTransform.parse(watchId, parser);
    }

    @Override
    public ExecutableScriptTransform createExecutable(ScriptTransform transform) {
        return new ExecutableScriptTransform(transform, this.transformLogger, this.scriptService);
    }
}

