/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform;

import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.watcher.support.Script;
import org.elasticsearch.watcher.transform.Transform;
import org.elasticsearch.watcher.transform.chain.ChainTransform;
import org.elasticsearch.watcher.transform.script.ScriptTransform;
import org.elasticsearch.watcher.transform.search.SearchTransform;

public final class TransformBuilders {
    private TransformBuilders() {
    }

    public static SearchTransform.Builder searchTransform(SearchRequest request) {
        return SearchTransform.builder(request);
    }

    public static SearchTransform.Builder searchTransform(SearchRequestBuilder request) {
        return TransformBuilders.searchTransform(request.request());
    }

    public static ScriptTransform.Builder scriptTransform(String script) {
        return TransformBuilders.scriptTransform(Script.inline(script));
    }

    public static ScriptTransform.Builder scriptTransform(Script.Builder script) {
        return TransformBuilders.scriptTransform(script.build());
    }

    public static ScriptTransform.Builder scriptTransform(Script script) {
        return ScriptTransform.builder(script);
    }

    public static ChainTransform.Builder chainTransform(Transform.Builder ... transforms) {
        return ChainTransform.builder(new Transform[0]).add(transforms);
    }

    public static ChainTransform.Builder chainTransform(Transform ... transforms) {
        return ChainTransform.builder(transforms);
    }
}

