/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.validation;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.support.Exceptions;

public class WatcherSettingsValidation
extends AbstractLifecycleComponent<WatcherSettingsValidation> {
    private List<String> errors = new ArrayList<String>();

    @Inject
    public WatcherSettingsValidation(Settings settings) {
        super(settings);
    }

    protected void doStart() throws ElasticsearchException {
        this.validate();
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    public void addError(String setting, String reason) {
        this.errors.add(LoggerMessageFormat.format((String)"", (String)"invalid [{}] setting value [{}]. {}", (Object[])new Object[]{setting, this.settings.get(setting), reason}));
    }

    private void validate() throws ElasticsearchException {
        if (this.errors.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder("encountered invalid watcher settings:\n");
        for (String error : this.errors) {
            sb.append("- ").append(error).append("\n");
        }
        throw Exceptions.invalidSettings(sb.toString(), new Object[0]);
    }
}

