/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.text.xmustache;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.watcher.support.ArrayObjectIterator;

public class XMustacheFactory
extends DefaultMustacheFactory {
    final XContentType contentType;

    public XMustacheFactory(XContentType contentType) {
        this.contentType = contentType;
        this.setObjectHandler((ObjectHandler)new ReflectionObjectHandler(){

            public Object coerce(Object object) {
                if (object != null) {
                    if (object.getClass().isArray()) {
                        return new ArrayMap(object);
                    }
                    if (object instanceof Collection) {
                        return new CollectionMap((Collection)object);
                    }
                }
                return super.coerce(object);
            }
        });
    }

    public void encode(String value, Writer writer) {
        try {
            if (this.contentType == XContentType.JSON) {
                writer.write(JsonStringEncoder.getInstance().quoteAsString(value));
            } else {
                writer.write(value);
            }
        }
        catch (IOException e) {
            throw new MustacheException("Failed to encode value: " + value);
        }
    }

    static class CollectionMap
    extends AbstractMap<Object, Object>
    implements Iterable<Object> {
        private final Collection col;

        public CollectionMap(Collection col) {
            this.col = col;
        }

        @Override
        public Object get(Object key) {
            if (key instanceof Number) {
                return Iterables.get((Iterable)this.col, (int)((Number)key).intValue());
            }
            try {
                int index = Integer.parseInt(key.toString());
                return Iterables.get((Iterable)this.col, (int)index);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            HashMap map = new HashMap(this.col.size());
            int i = 0;
            for (Object item : this.col) {
                map.put(i++, item);
            }
            return map.entrySet();
        }

        @Override
        public Iterator<Object> iterator() {
            return this.col.iterator();
        }
    }

    static class ArrayMap
    extends AbstractMap<Object, Object>
    implements Iterable<Object> {
        private final Object array;

        public ArrayMap(Object array) {
            this.array = array;
        }

        @Override
        public Object get(Object key) {
            if (key instanceof Number) {
                return Array.get(this.array, ((Number)key).intValue());
            }
            try {
                int index = Integer.parseInt(key.toString());
                return Array.get(this.array, index);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            int length = Array.getLength(this.array);
            HashMap<Integer, Object> map = new HashMap<Integer, Object>(length);
            for (int i = 0; i < length; ++i) {
                map.put(i, Array.get(this.array, i));
            }
            return map.entrySet();
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayObjectIterator(this.array);
        }
    }
}

