/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.secret;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.shield.ShieldIntegration;
import org.elasticsearch.watcher.shield.ShieldSecretService;
import org.elasticsearch.watcher.support.secret.SecretService;

public class SecretModule
extends AbstractModule {
    private final boolean shieldEnabled;

    public SecretModule(Settings settings) {
        this.shieldEnabled = ShieldIntegration.enabled(settings);
    }

    protected void configure() {
        if (this.shieldEnabled) {
            this.bind(ShieldSecretService.class).asEagerSingleton();
            this.bind(SecretService.class).to(ShieldSecretService.class);
        } else {
            this.bind(SecretService.PlainText.class).asEagerSingleton();
            this.bind(SecretService.class).to(SecretService.PlainText.class);
        }
    }
}

