/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.http;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public enum Scheme implements ToXContent
{
    HTTP("http"),
    HTTPS("https");

    private final String scheme;

    private Scheme(String scheme) {
        this.scheme = scheme;
    }

    public String scheme() {
        return this.scheme;
    }

    public static Scheme parse(String value) {
        switch (value = value.toLowerCase(Locale.ROOT)) {
            case "http": {
                return HTTP;
            }
            case "https": {
                return HTTPS;
            }
        }
        throw new IllegalArgumentException("unsupported http scheme [" + value + "]");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.name().toLowerCase(Locale.ROOT));
    }
}

