/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.clock;

import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.watcher.support.clock.Clock;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class SystemClock
implements Clock {
    public static final SystemClock INSTANCE = new SystemClock();

    private SystemClock() {
    }

    @Override
    public long millis() {
        return System.currentTimeMillis();
    }

    @Override
    public long nanos() {
        return System.nanoTime();
    }

    @Override
    public DateTime nowUTC() {
        return this.now(DateTimeZone.UTC);
    }

    @Override
    public DateTime now(DateTimeZone timeZone) {
        return DateTime.now((DateTimeZone)timeZone);
    }

    @Override
    public TimeValue timeElapsedSince(DateTime time) {
        return TimeValue.timeValueMillis((long)(this.millis() - time.getMillis()));
    }
}

