/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.clock;

import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.watcher.support.clock.Clock;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HaltedClock
implements Clock {
    private final DateTime now;

    public HaltedClock(DateTime now) {
        this.now = now.toDateTime(DateTimeZone.UTC);
    }

    @Override
    public long millis() {
        return this.now.getMillis();
    }

    @Override
    public long nanos() {
        return this.millis() * 1000000L;
    }

    @Override
    public DateTime nowUTC() {
        return this.now;
    }

    @Override
    public DateTime now(DateTimeZone timeZone) {
        return this.now.toDateTime(timeZone);
    }

    @Override
    public TimeValue timeElapsedSince(DateTime time) {
        return TimeValue.timeValueMillis((long)(this.millis() - time.getMillis()));
    }
}

