/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.text.TextTemplate;
import org.elasticsearch.watcher.watch.Payload;
import org.joda.time.DateTime;

public final class WatcherUtils {
    static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    static final ParseField TYPES_FIELD = new ParseField("types", new String[0]);
    static final ParseField BODY_FIELD = new ParseField("body", new String[0]);
    static final ParseField SEARCH_TYPE_FIELD = new ParseField("search_type", new String[0]);
    static final ParseField INDICES_OPTIONS_FIELD = new ParseField("indices_options", new String[0]);
    static final ParseField EXPAND_WILDCARDS_FIELD = new ParseField("expand_wildcards", new String[0]);
    static final ParseField IGNORE_UNAVAILABLE_FIELD = new ParseField("ignore_unavailable", new String[0]);
    static final ParseField ALLOW_NO_INDICES_FIELD = new ParseField("allow_no_indices", new String[0]);
    static final ParseField TEMPLATE_FIELD = new ParseField("template", new String[0]);
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.lenientExpandOpen();

    private WatcherUtils() {
    }

    public static Map<String, Object> responseToData(ToXContent response) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().value((Object)response).endObject();
        return (Map)XContentHelper.convertToMap((BytesReference)builder.bytes(), (boolean)false).v2();
    }

    public static SearchRequest createSearchRequestFromPrototype(SearchRequest requestPrototype, WatchExecutionContext ctx, Payload payload) throws IOException {
        SearchRequest request = new SearchRequest((ActionRequest)requestPrototype).indicesOptions(requestPrototype.indicesOptions()).searchType(requestPrototype.searchType()).indices(requestPrototype.indices()).types(requestPrototype.types());
        Map<String, Object> watcherContextParams = Variables.createCtxModel(ctx, payload);
        if (Strings.hasLength((BytesReference)requestPrototype.source())) {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            XContentHelper.writeRawField((String)"template", (BytesReference)requestPrototype.source(), (XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
            builder.field("params", watcherContextParams);
            builder.endObject();
            request.templateSource(builder.string());
        } else if (Strings.hasLength((BytesReference)requestPrototype.templateSource())) {
            BytesReference templateSource = requestPrototype.templateSource();
            try (XContentParser sourceParser = XContentFactory.xContent((BytesReference)templateSource).createParser(templateSource);){
                sourceParser.nextToken();
                TextTemplate template = TextTemplate.parse(sourceParser);
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.startObject();
                switch (template.getType()) {
                    case INDEXED: {
                        builder.startObject("template");
                        builder.field("id", template.getTemplate());
                        builder.endObject();
                        break;
                    }
                    case FILE: {
                        builder.startObject("template");
                        builder.field("file", template.getTemplate());
                        builder.endObject();
                        break;
                    }
                    case INLINE: {
                        XContentHelper.writeRawField((String)"template", (BytesReference)new BytesArray(template.getTemplate()), (XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
                    }
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.putAll(watcherContextParams);
                params.putAll(template.getParams());
                builder.field("params", params);
                builder.endObject();
                request.templateSource(builder.string());
            }
        } else if (requestPrototype.templateName() != null) {
            throw Exceptions.illegalArgument("SearchRequest's templateName isn't supported, templates should be defined in the request body", new Object[0]);
        }
        return request;
    }

    public static SearchRequest readSearchRequest(XContentParser parser, SearchType searchType) throws IOException {
        XContentParser.Token token;
        BytesReference searchBody = null;
        String templateBody = null;
        IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
        SearchRequest searchRequest = new SearchRequest();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, INDICES_FIELD)) {
                    ArrayList<String> indices = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            indices.add(parser.textOrNull());
                            continue;
                        }
                        throw new ElasticsearchParseException("could not read search request. expected string values in [" + currentFieldName + "] field, but instead found [" + token + "]", new Object[0]);
                    }
                    searchRequest.indices(indices.toArray(new String[indices.size()]));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, TYPES_FIELD)) {
                    ArrayList<String> types = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            types.add(parser.textOrNull());
                            continue;
                        }
                        throw new ElasticsearchParseException("could not read search request. expected string values in [" + currentFieldName + "] field, but instead found [" + token + "]", new Object[0]);
                    }
                    searchRequest.types(types.toArray(new String[types.size()]));
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected array field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, BODY_FIELD)) {
                    XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());
                    builder.copyCurrentStructure(parser);
                    searchBody = builder.bytes();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, INDICES_OPTIONS_FIELD)) {
                    boolean expandOpen = DEFAULT_INDICES_OPTIONS.expandWildcardsOpen();
                    boolean expandClosed = DEFAULT_INDICES_OPTIONS.expandWildcardsClosed();
                    boolean allowNoIndices = DEFAULT_INDICES_OPTIONS.allowNoIndices();
                    boolean ignoreUnavailable = DEFAULT_INDICES_OPTIONS.ignoreUnavailable();
                    block15: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (ParseFieldMatcher.STRICT.match(currentFieldName, EXPAND_WILDCARDS_FIELD)) {
                                switch (parser.text()) {
                                    case "all": {
                                        expandOpen = true;
                                        expandClosed = true;
                                        continue block15;
                                    }
                                    case "open": {
                                        expandOpen = true;
                                        expandClosed = false;
                                        continue block15;
                                    }
                                    case "closed": {
                                        expandOpen = false;
                                        expandClosed = true;
                                        continue block15;
                                    }
                                    case "none": {
                                        expandOpen = false;
                                        expandClosed = false;
                                        continue block15;
                                    }
                                }
                                throw new ElasticsearchParseException("could not read search request. unknown value [" + parser.text() + "] for [" + currentFieldName + "] field ", new Object[0]);
                            }
                            if (ParseFieldMatcher.STRICT.match(currentFieldName, IGNORE_UNAVAILABLE_FIELD)) {
                                ignoreUnavailable = parser.booleanValue();
                                continue;
                            }
                            if (ParseFieldMatcher.STRICT.match(currentFieldName, ALLOW_NO_INDICES_FIELD)) {
                                allowNoIndices = parser.booleanValue();
                                continue;
                            }
                            throw new ElasticsearchParseException("could not read search request. unexpected index option [" + currentFieldName + "]", new Object[0]);
                        }
                        throw new ElasticsearchParseException("could not read search request. unexpected object field [" + currentFieldName + "]", new Object[0]);
                    }
                    indicesOptions = IndicesOptions.fromOptions((boolean)ignoreUnavailable, (boolean)allowNoIndices, (boolean)expandOpen, (boolean)expandClosed, (IndicesOptions)DEFAULT_INDICES_OPTIONS);
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, TEMPLATE_FIELD)) {
                    XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());
                    builder.copyCurrentStructure(parser);
                    templateBody = builder.string();
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected object field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, INDICES_FIELD)) {
                    String indicesStr = parser.text();
                    searchRequest.indices(Strings.delimitedListToStringArray((String)indicesStr, (String)",", (String)" \t"));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, TYPES_FIELD)) {
                    String typesStr = parser.text();
                    searchRequest.types(Strings.delimitedListToStringArray((String)typesStr, (String)",", (String)" \t"));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, SEARCH_TYPE_FIELD)) {
                    searchType = SearchType.fromString((String)parser.text().toLowerCase(Locale.ROOT), (ParseFieldMatcher)ParseFieldMatcher.EMPTY);
                    if (searchType != SearchType.SCAN) continue;
                    throw new ElasticsearchParseException("could not read search request. value [" + searchType.name() + "] is not supported for field [" + SEARCH_TYPE_FIELD.getPreferredName() + "]", new Object[0]);
                }
                throw new ElasticsearchParseException("could not read search request. unexpected string field [" + currentFieldName + "]", new Object[0]);
            }
            throw new ElasticsearchParseException("could not read search request. unexpected token [" + token + "]", new Object[0]);
        }
        if (searchRequest.indices() == null) {
            searchRequest.indices(Strings.EMPTY_ARRAY);
        }
        searchRequest.searchType(searchType);
        searchRequest.indicesOptions(indicesOptions);
        if (searchBody != null) {
            assert (searchBody.hasArray());
            searchRequest.source(searchBody.array(), searchBody.arrayOffset(), searchBody.length());
        }
        if (templateBody != null) {
            searchRequest.templateSource(templateBody);
        }
        return searchRequest;
    }

    public static XContentBuilder writeSearchRequest(SearchRequest searchRequest, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (searchRequest == null) {
            builder.nullValue();
            return builder;
        }
        builder.startObject();
        if (searchRequest.searchType() != null) {
            builder.field(SEARCH_TYPE_FIELD.getPreferredName(), searchRequest.searchType().toString().toLowerCase(Locale.ENGLISH));
        }
        if (searchRequest.indices() != null) {
            builder.array(INDICES_FIELD.getPreferredName(), searchRequest.indices());
        }
        if (searchRequest.types() != null) {
            builder.array(TYPES_FIELD.getPreferredName(), searchRequest.types());
        }
        if (Strings.hasLength((BytesReference)searchRequest.source())) {
            XContentHelper.writeRawField((String)BODY_FIELD.getPreferredName(), (BytesReference)searchRequest.source(), (XContentBuilder)builder, (ToXContent.Params)params);
        }
        if (Strings.hasLength((BytesReference)searchRequest.templateSource())) {
            XContentHelper.writeRawField((String)TEMPLATE_FIELD.getPreferredName(), (BytesReference)searchRequest.templateSource(), (XContentBuilder)builder, (ToXContent.Params)params);
        }
        if (searchRequest.indicesOptions() != DEFAULT_INDICES_OPTIONS) {
            IndicesOptions options = searchRequest.indicesOptions();
            builder.startObject(INDICES_OPTIONS_FIELD.getPreferredName());
            String value = options.expandWildcardsClosed() && options.expandWildcardsOpen() ? "all" : (options.expandWildcardsOpen() ? "open" : (options.expandWildcardsClosed() ? "closed" : "none"));
            builder.field(EXPAND_WILDCARDS_FIELD.getPreferredName(), value);
            builder.field(IGNORE_UNAVAILABLE_FIELD.getPreferredName(), options.ignoreUnavailable());
            builder.field(ALLOW_NO_INDICES_FIELD.getPreferredName(), options.allowNoIndices());
            builder.endObject();
        }
        return builder.endObject();
    }

    public static Map<String, Object> flattenModel(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WatcherUtils.flattenModel("", map, result);
        return result;
    }

    private static void flattenModel(String key, Object value, Map<String, Object> result) {
        if (value == null) {
            result.put(key, null);
            return;
        }
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if ("".equals(key)) {
                    WatcherUtils.flattenModel((String)entry.getKey(), entry.getValue(), result);
                    continue;
                }
                WatcherUtils.flattenModel(key + "." + (String)entry.getKey(), entry.getValue(), result);
            }
            return;
        }
        if (value instanceof Iterable) {
            int i = 0;
            for (Object item : (Iterable)value) {
                WatcherUtils.flattenModel(key + "." + i++, item, result);
            }
            return;
        }
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                WatcherUtils.flattenModel(key + "." + i, Array.get(value, i), result);
            }
            return;
        }
        if (value instanceof DateTime) {
            result.put(key, WatcherDateTimeUtils.formatDate((DateTime)value));
            return;
        }
        if (value instanceof TimeValue) {
            result.put(key, String.valueOf(((TimeValue)value).getMillis()));
            return;
        }
        result.put(key, String.valueOf(value));
    }
}

