/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.watcher.client.WatcherClient;
import org.elasticsearch.watcher.rest.WatcherRestHandler;
import org.elasticsearch.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.watcher.transport.actions.get.GetWatchResponse;

public class RestGetWatchAction
extends WatcherRestHandler {
    @Inject
    public RestGetWatchAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, URI_BASE + "/watch/{id}", (RestHandler)this);
    }

    @Override
    protected void handleRequest(final RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
        GetWatchRequest getWatchRequest = new GetWatchRequest(request.param("id"));
        client.getWatch(getWatchRequest, (ActionListener<GetWatchResponse>)new RestBuilderListener<GetWatchResponse>(channel){

            public RestResponse buildResponse(GetWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject().field("found", response.isFound()).field("_id", response.getId());
                if (response.isFound()) {
                    WatcherParams params = WatcherParams.builder((ToXContent.Params)request).put("include_version", true).build();
                    builder.field("_status", (ToXContent)response.getStatus(), (ToXContent.Params)params);
                    builder.field("watch", (ToXContent)response.getSource(), (ToXContent.Params)params);
                }
                builder.endObject();
                RestStatus status = response.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

