/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.license;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.core.License;
import org.elasticsearch.license.plugin.core.AbstractLicenseeComponent;
import org.elasticsearch.license.plugin.core.LicenseState;
import org.elasticsearch.license.plugin.core.Licensee;
import org.elasticsearch.license.plugin.core.LicenseeRegistry;

public class WatcherLicensee
extends AbstractLicenseeComponent<WatcherLicensee> {
    public static final String ID = "watcher";

    @Inject
    public WatcherLicensee(Settings settings, LicenseeRegistry clientService) {
        super(settings, ID, clientService);
    }

    public String[] expirationMessages() {
        return new String[]{"PUT / GET watch APIs are disabled, DELETE watch API continues to work", "Watches execute and write to the history", "The actions of the watches don't execute"};
    }

    public String[] acknowledgmentMessages(License currentLicense, License newLicense) {
        switch (newLicense.operationMode()) {
            case BASIC: {
                if (currentLicense == null) break;
                switch (currentLicense.operationMode()) {
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{"Watcher will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    public boolean isExecutingActionsAllowed() {
        return this.isPutWatchAllowed();
    }

    public boolean isGetWatchAllowed() {
        return this.isPutWatchAllowed();
    }

    public boolean isPutWatchAllowed() {
        return this.isWatcherTransportActionAllowed();
    }

    public boolean isWatcherTransportActionAllowed() {
        Licensee.Status localStatus = this.status;
        boolean isLicenseStateActive = localStatus.getLicenseState() != LicenseState.DISABLED;
        License.OperationMode operationMode = localStatus.getMode();
        return isLicenseStateActive && (operationMode == License.OperationMode.TRIAL || operationMode == License.OperationMode.GOLD || operationMode == License.OperationMode.PLATINUM);
    }
}

