/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.none;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.input.Input;
import org.elasticsearch.watcher.watch.Payload;

public class NoneInput
implements Input {
    public static final String TYPE = "none";
    public static final NoneInput INSTANCE = new NoneInput();

    private NoneInput() {
    }

    @Override
    public String type() {
        return TYPE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().endObject();
    }

    public static NoneInput parse(String watchId, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. expected an empty object but found [{}] instead", new Object[]{TYPE, watchId, parser.currentToken()});
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. expected an empty object but found [{}] instead", new Object[]{TYPE, watchId, parser.currentToken()});
        }
        return INSTANCE;
    }

    public static Builder builder() {
        return Builder.INSTANCE;
    }

    public static class Builder
    implements Input.Builder<NoneInput> {
        private static final Builder INSTANCE = new Builder();

        private Builder() {
        }

        @Override
        public NoneInput build() {
            return INSTANCE;
        }
    }

    public static class Result
    extends Input.Result {
        static final Result INSTANCE = new Result();

        private Result() {
            super(NoneInput.TYPE, Payload.EMPTY);
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }
    }
}

