/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.history;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.watcher.execution.ExecutionState;
import org.elasticsearch.watcher.history.WatchRecord;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.support.init.proxy.ClientProxy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class HistoryStore
extends AbstractComponent {
    public static final String INDEX_PREFIX = ".watch_history-";
    public static final String DOC_TYPE = "watch_record";
    static final DateTimeFormatter indexTimeFormat = DateTimeFormat.forPattern((String)"YYYY.MM.dd");
    private static final ImmutableSet<String> forbiddenIndexSettings = ImmutableSet.of((Object)"index.mapper.dynamic");
    private final ClientProxy client;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock putUpdateLock = this.readWriteLock.readLock();
    private final Lock stopLock = this.readWriteLock.writeLock();
    private final AtomicBoolean started = new AtomicBoolean(false);

    @Inject
    public HistoryStore(Settings settings, ClientProxy client) {
        super(settings);
        this.client = client;
    }

    public void start() {
        this.started.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopLock.lock();
        try {
            this.started.set(false);
        }
        finally {
            this.stopLock.unlock();
        }
    }

    public void put(WatchRecord watchRecord) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("unable to persist watch record history store is not ready");
        }
        String index = HistoryStore.getHistoryIndexNameForTime(watchRecord.triggerEvent().triggeredTime());
        this.putUpdateLock.lock();
        try {
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(XContentFactory.jsonBuilder().value((Object)watchRecord)).opType(IndexRequest.OpType.CREATE);
            this.client.index(request, (TimeValue)null);
        }
        catch (IOException ioe) {
            throw Exceptions.ioException("failed to persist watch record [{}]", ioe, watchRecord);
        }
        finally {
            this.putUpdateLock.unlock();
        }
    }

    public void forcePut(WatchRecord watchRecord) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("unable to persist watch record history store is not ready");
        }
        String index = HistoryStore.getHistoryIndexNameForTime(watchRecord.triggerEvent().triggeredTime());
        this.putUpdateLock.lock();
        try {
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(XContentFactory.jsonBuilder().value((Object)watchRecord)).opType(IndexRequest.OpType.CREATE);
            this.client.index(request, (TimeValue)null);
        }
        catch (DocumentAlreadyExistsException daee) {
            this.logger.warn("watch record [{}] has executed multiple times, this can happen during watcher restarts", new Object[]{watchRecord});
            watchRecord = new WatchRecord(watchRecord, ExecutionState.EXECUTED_MULTIPLE_TIMES, "watch record has been stored before, previous state [" + (Object)((Object)watchRecord.state()) + "]");
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(XContentFactory.jsonBuilder().value((Object)watchRecord));
            this.client.index(request, (TimeValue)null);
        }
        catch (IOException ioe) {
            throw Exceptions.ioException("failed to persist watch record [{}]", ioe, watchRecord);
        }
        finally {
            this.putUpdateLock.unlock();
        }
    }

    public static String getHistoryIndexNameForTime(DateTime time) {
        return INDEX_PREFIX + indexTimeFormat.print((ReadableInstant)time);
    }
}

