/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.execution;

import com.google.common.collect.Iterables;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.execution.ExecutionService;
import org.elasticsearch.watcher.trigger.TriggerEngine;
import org.elasticsearch.watcher.trigger.TriggerEvent;
import org.elasticsearch.watcher.trigger.TriggerService;

public class SyncTriggerListener
implements TriggerEngine.Listener {
    private final ExecutionService executionService;
    private final ESLogger logger;

    @Inject
    public SyncTriggerListener(Settings settings, ExecutionService executionService, TriggerService triggerService) {
        this.logger = Loggers.getLogger(SyncTriggerListener.class, (Settings)settings, (String[])new String[0]);
        this.executionService = executionService;
        triggerService.register(this);
    }

    @Override
    public void triggered(Iterable<TriggerEvent> events) {
        try {
            this.executionService.processEventsSync(events);
        }
        catch (Exception e) {
            this.logger.error("failed to process triggered events [{}]", (Throwable)e, new Object[]{Iterables.toArray(events, TriggerEvent.class)});
        }
    }
}

