/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.execution;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class QueuedWatch
implements Streamable,
ToXContent {
    private String watchId;
    private String watchRecordId;
    private DateTime triggeredTime;
    private DateTime executionTime;

    public QueuedWatch(WatchExecutionContext ctx) {
        this.watchId = ctx.watch().id();
        this.watchRecordId = ctx.id().value();
        this.triggeredTime = ctx.triggerEvent().triggeredTime();
        this.executionTime = ctx.executionTime();
    }

    public QueuedWatch(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    public String watchId() {
        return this.watchId;
    }

    public void WatchId(String watchId) {
        this.watchId = watchId;
    }

    public String watchRecordId() {
        return this.watchRecordId;
    }

    public void watchRecordId(String watchRecordId) {
        this.watchRecordId = watchRecordId;
    }

    public DateTime triggeredTime() {
        return this.triggeredTime;
    }

    public void triggeredTime(DateTime triggeredTime) {
        this.triggeredTime = triggeredTime;
    }

    public DateTime executionTime() {
        return this.executionTime;
    }

    public void executionTime(DateTime executionTime) {
        this.executionTime = executionTime;
    }

    public void readFrom(StreamInput in) throws IOException {
        this.watchId = in.readString();
        this.watchRecordId = in.readString();
        this.triggeredTime = new DateTime(in.readVLong(), DateTimeZone.UTC);
        this.executionTime = new DateTime(in.readVLong(), DateTimeZone.UTC);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.watchId);
        out.writeString(this.watchRecordId);
        out.writeVLong(this.triggeredTime.getMillis());
        out.writeVLong(this.executionTime.getMillis());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("watch_id", this.watchId);
        builder.field("watch_record_id", this.watchRecordId);
        builder.field("triggered_time", (ReadableInstant)this.triggeredTime);
        builder.field("execution_time", (ReadableInstant)this.executionTime);
        builder.endObject();
        return builder;
    }
}

