/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.execution;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.watcher.execution.AsyncTriggerListener;
import org.elasticsearch.watcher.execution.ExecutionService;
import org.elasticsearch.watcher.execution.InternalWatchExecutor;
import org.elasticsearch.watcher.execution.TriggeredWatch;
import org.elasticsearch.watcher.execution.TriggeredWatchStore;
import org.elasticsearch.watcher.execution.WatchExecutor;
import org.elasticsearch.watcher.trigger.TriggerEngine;

public class ExecutionModule
extends AbstractModule {
    private final Class<? extends WatchExecutor> executorClass;
    private final Class<? extends TriggerEngine.Listener> triggerEngineListenerClass;

    public ExecutionModule() {
        this(InternalWatchExecutor.class, AsyncTriggerListener.class);
    }

    protected ExecutionModule(Class<? extends WatchExecutor> executorClass, Class<? extends TriggerEngine.Listener> triggerEngineListenerClass) {
        this.executorClass = executorClass;
        this.triggerEngineListenerClass = triggerEngineListenerClass;
    }

    protected void configure() {
        this.bind(TriggeredWatch.Parser.class).asEagerSingleton();
        this.bind(TriggeredWatchStore.class).asEagerSingleton();
        this.bind(ExecutionService.class).asEagerSingleton();
        this.bind(this.executorClass).asEagerSingleton();
        this.bind(this.triggerEngineListenerClass).asEagerSingleton();
        this.bind(WatchExecutor.class).to(this.executorClass);
    }
}

