/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.never;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.Condition;

public class NeverCondition
implements Condition {
    public static final String TYPE = "never";
    public static final NeverCondition INSTANCE = new NeverCondition();

    @Override
    public final String type() {
        return TYPE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().endObject();
    }

    public static NeverCondition parse(String watchId, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an empty object but found [{}]", new Object[]{TYPE, watchId, parser.currentName()});
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an empty object but found [{}]", new Object[]{TYPE, watchId, parser.currentName()});
        }
        return INSTANCE;
    }

    public static class Builder
    implements Condition.Builder<NeverCondition> {
        public static final Builder INSTANCE = new Builder();

        @Override
        public NeverCondition build() {
            return INSTANCE;
        }
    }

    public static class Result
    extends Condition.Result {
        public static final Result INSTANCE = new Result();

        private Result() {
            super(NeverCondition.TYPE, false);
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }
    }
}

